#include <assert.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>
#include <sys/stat.h>
#include "common.h"

void main(int argc, char **argv) {
  int i, n;
  BanRec br;
  char tBanPath[16], phNo[32];
  FILE *tBanFile;
  processConfig();
  if (argc < 2)
    errQuit("usage: user_unban <phone_no>");
  strcpy(phNo, argv[1]);
  for (i = 2; argv[i]; i++) {
    strcat(phNo, " ");
    strcat(phNo, argv[i]);
  }
  if (phNo2Words(&br.phNoArea, &br.phNoLocal, phNo, phNoDigits))
    errQuit("invalid phone number: %s", phNo);
  strcpy(tBanPath, "/tmp/XXXXXX"); mktemp(tBanPath);
  banFileOpen();
  if (banFileSearch(&br, br.phNoArea, br.phNoLocal))
    errQuit("phone number not found: %s", phNo);
  tBanFile = fopen(tBanPath, "wb"); assert(tBanFile != NULL);
  n = ftell(banFile) / sizeof(BanRec) - 1;
  rewind(banFile);
  for (i = 0; ; i++) {
    if (banFileRead(&br)) break;
    if (i == n) continue;
    fwrite(&br, sizeof(BanRec), 1, tBanFile);
  }
  fclose(tBanFile);
  rename(tBanPath, banFilePath); chmod(banFilePath, 0644);
  banFileClose();
  printf("phone number unbanned: %s\n", phNo);
  exit(0);
}
