#include <assert.h>
#include <unistd.h>
#include "common.h"

void main(int argc, char **argv) {
  uid_t uid;
  UserRec ur;
  processConfig();
  if (argc != 2)
    errQuit("usage: user_touch <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  ur.last = time(NULL);
  userFileEdit(&ur);
  printf("user touched: %s\n", argv[1]);
  userFileClose();
  exit(0);
}
