#include <assert.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "common.h"

void	usage();

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  UserRec ur;
  processConfig();
  if (argc < 3) usage();
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (argc == 3 && (argv[2][0] == '+' || argv[2][0] == '-')) {
    ushort mask = 0;
    if (!strcasecmp(argv[2] + 1, "SMARTBOOT")) mask = FLG_SMARTBOOT;
    else if (!strcasecmp(argv[2] + 1, "SSMARTBOOT")) mask = FLG_SSMARTBOOT;
    else if (!strcasecmp(argv[2] + 1, "IBOOT")) mask = FLG_IBOOT;
    else if (!strcasecmp(argv[2] + 1, "ISMARTBOOT")) mask = FLG_ISMARTBOOT;
    else if (!strcasecmp(argv[2] + 1, "TCSMARTBOOT")) mask = FLG_TCSMARTBOOT;
    else errQuit("unknown flag: %s", argv[2] + 1);
    if (argv[2][0] == '+') ur.flags |= mask;
    else ur.flags &= ~mask;
  } else if (!isdigit(argv[2][0])) {
    if (argc == 5) {
      if (!strcasecmp(argv[2], "priority")) {
	ur.flags &= ~FLG_PRIORITY;
	ur.flags |= atoi(argv[4]) << 13;
      } else if (argv[2][0] == 'b') {
 	int t = atol(argv[4]);
	dword *p = NULL;
	if (!strcasecmp(argv[2], "bTotal")) p = &ur.bTotal;
	else if (!strcasecmp(argv[2], "btLimit")) p = &ur.btLimit;
	else if (!strcasecmp(argv[2], "bsLimit")) p = &ur.bsLimit;
	else errQuit("unknown field: %s", argv[2]);
	if (!strcmp(argv[3], "+=")) *p += t;
	else if (!strcmp(argv[3], "-=")) *p -= t;
	else if (!strcmp(argv[3], "=")) *p = t;
	else errQuit("unknown operator: %s", argv[3]);
      } else {
	int t = atoi(argv[4]);
	int *p = NULL;
 	if (!strcasecmp(argv[2], "tLeft")) p = &ur.tLeft;
	else if (!strcasecmp(argv[2], "tLimit")) p = &ur.tLimit;
	else if (!strcasecmp(argv[2], "sLeft")) p = &ur.sLeft;
	else if (!strcasecmp(argv[2], "sLimit")) p = &ur.sLimit;
	else errQuit("unknown field: %s", argv[2]);
	if (!strcmp(argv[3], "+=")) *p += t;
	else if (!strcmp(argv[3], "-=")) *p -= t;
	else if (!strcmp(argv[3], "=")) *p = t;
	else errQuit("unknown operator: %s", argv[3]);
      }
    } else if (argc == 6) {
      int c = atoi(argv[3]);
      int t = atoi(argv[5]);
      short *p = NULL;
      if (!strncasecmp(argv[2], "cLeft", 5)) {
        if (c < 0 || c >= MAX_TIME_CLASSES) errQuit("invalid time class: ", argv[3]);
        p = &ur.cLeft[c]; 
      } else if (!strncasecmp(argv[2], "cLimit", 6)) {
        if (c < 0 || c >= MAX_TIME_CLASSES) errQuit("invalid time class: ", argv[3]);
        p = &ur.cLimit[c]; 
      } else errQuit("unknown field: %s", argv[2]);
      if (!strcmp(argv[4], "+=")) *p += t;
      else if (!strcmp(argv[4], "-=")) *p -= t;
      else if (!strcmp(argv[4], "=")) *p = t;
      else errQuit("unknown operator: %s", argv[4]);
    } else usage();
  } else if (argc >= 4) {
    int session_limit, priority;
    session_limit = argc >= 5 ? atoi(argv[4]) : atoi(argv[3]);
    if (session_limit < 0 || session_limit > atoi(argv[3]))
      errQuit("invalid session_limit: %d", session_limit);
    priority = argc >= 6 ? atoi(argv[5]) : 4;
    if (priority < 0 || priority > 7)
      errQuit("invalid priority: %d", priority);
    ur.flags = (ur.flags & ~FLG_PRIORITY) | (priority << 13);
    ur.expire = addTime(argv[2]);
    if (EXPIRE(ur.flags) == EXPIRE_UNSUBSCRIBE && !ur.expire)
      errQuit("<expire> = 0 invalid (user %s has a subscription).", argv[1]);
    ur.tLeft = ur.tLimit = atoi(argv[3]);
    ur.sLeft = ur.sLimit = session_limit;
    for (i = 0; i < MAX_TIME_CLASSES; i++)
      ur.cLeft[i] = ur.cLimit[i] = -1;
    for (i = 6; i < min(6 + MAX_TIME_CLASSES, argc); i++)
      ur.cLeft[i - 6] = ur.cLimit[i - 6] = atoi(argv[i]);
  } else usage();
  userFileEdit(&ur);
  userFileClose();
  printf("user modified: %s\n", argv[1]);
  exit(0);
}

void usage() {
  errQuit("\
usage: user_time\n\
       <login> <expire> <time_limit> [session_limit] [priority] {class_limit}\n\
     | <login> <+|-><SMARTBOOT>|<SSMARTBOOT>|<IBOOT>|<ISMARTBOOT>|<TCSMARTBOOT>\n\
     | <login> <tLeft>|<tLimit>|<sLeft>|<sLimit> <+=|-=|=> <minutes>\n\
     | <login> <cLeft>|<cLimit> <class> <+=|-=|=> <minutes>\n\
     | <login> <bTotal>|<btLimit>|<bsLimit> <+=|-=|=> <bytes>\n\
     | <login> priority = <priority>");
}
