#include <assert.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/stat.h>
#include "common.h"

int		search(uid_t uid, FILE *f);

void main() {
  UserRec ur;
  char tmpUserPath[16];
  FILE *tmpUser;
  strcpy(tmpUserPath, "/tmp/XXXXXX"); mktemp(tmpUserPath);
  processConfig();
  userFileOpen();
  tmpUser = fopen(tmpUserPath, "w+b"); assert(tmpUser != NULL);
  while (!userFileRead(&ur))
    if (getpwuid(ur.uid) && search(ur.uid, tmpUser)) {
      fseek(tmpUser, 0, SEEK_END);
      fwrite(&ur, sizeof(UserRec), 1, tmpUser);
    }
  fclose(tmpUser);
  rename(tmpUserPath, userFilePath); chmod(userFilePath, 0644);
  userFileClose();
  exit(0);
}

int search(uid_t uid, FILE *f) {
  int res = 1;
  UserRec ur;
  rewind(f);
  while (fread(&ur, sizeof(UserRec), 1, f)) {
    if (ur.uid == uid) {
      res = 0;
      break;
    }
  }
  return res;
}
