#include <assert.h>
#include <stdlib.h>
#include <unistd.h>
#include "common.h"

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  UserRec ur;
  int session_limit, priority;
  char tuser[16];
  processConfig();
  if (argc < 4)
    errQuit("\
usage: user_subscribe <login> <expire> <time_limit> [session_limit] [priority]\n\
                      {class_limit}");
  session_limit = argc >= 5 ? atoi(argv[4]) : atoi(argv[3]);
  priority = argc >= 6 ? atoi(argv[5]) : 4;
  if (priority < 0 || priority > 7)
    errQuit("invalid priority: %d", priority);
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  strcpy(tuser, "/tmp/XXXXXX"); mktemp(tuser);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (EXPIRE(ur.flags) == EXPIRE_UNSUBSCRIBE)
    errQuit("user already has a subscription: %s", argv[1]);
  ur.subExpire = ur.expire;
  ur.subFlags = ur.flags;
  ur.subTlimit = ur.tLimit;
  ur.subSlimit = ur.sLimit;
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.subClimit[i] = ur.cLimit[i];
  ur.subBTlimit = ur.btLimit;
  ur.subBSlimit = ur.bsLimit;
  ur.expire = addTime(argv[2]);
  if (ur.expire <= time(NULL))
    errQuit("illegal expiry date.");
  ur.tLimit = ur.tLeft = atoi(argv[3]);
  ur.sLimit = ur.sLeft = session_limit;
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.cLeft[i] = ur.cLimit[i] = -1;
  for (i = 6; i < min(6 + MAX_TIME_CLASSES, argc); i++)
    ur.cLeft[i - 6] = ur.cLimit[i - 6] = atoi(argv[i]);
  ur.flags &= ~FLG_PRIORITY;
  ur.flags |= priority << 13;
  ur.flags &= ~FLG_EXPIRE;
  ur.flags |= EXPIRE_UNSUBSCRIBE;
  userFileEdit(&ur);
  userFileClose();
  printf("user subscribed: %s\n", argv[1]);
  exit(0);
}
