#include <assert.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>
#include "common.h"

int		purge_user(int days);

void main(int argc, char **argv) {
  int days;
  processConfig();
  if (argc != 2)
    errQuit("usage: user_purge <days>");
  days = atoi(argv[1]);
  if (days <= 14)
    errQuit("<days> must be > 14.");
  while (!purge_user(days));
  exit(0);
}

int purge_user(int days) {
  time_t t;
  char login[9];
  UserRec ur;
  userFileOpen();
  time(&t);
  while (!userFileRead(&ur)) {
    if ((t - ur.last) / (24 * 60 * 60) >= days) {
      userFileClose();
      loginFromUID(login, ur.uid);
      runCommand(SBIN"/user_del", login, NULL);
      return 0;
    }
  }
  userFileClose();
  return 1;
}
