#include <ctype.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "common.h"

#define		MSG_DEFAULT		0
#define		MSG_ALREADY_ONLINE	1
#define		MSG_BUSY		2
#define		MSG_DATA_PERIOD		3
#define		MSG_TIME_CLASS		4
#define		MSG_TIME_PERIOD		5
#define		MSG_SESSION_WAIT	6

void		printFile(char *path);

const char	*msgPath[7] = { LIB"/user_login.default", LIB"/user_login.already_online", LIB"/user_login.busy", LIB"/user_login.data_period", LIB"/user_login.time_class", LIB"/user_login.time_period", LIB"/user_login.session_wait" };

int		nLogins;
LoginRec	loginRec[MAX_USERS];
int		nProcs;
ProcRec		procRec[MAX_PROCS];

void main(int argc, char **argv) {
  int i, j, msg = -1, found = 0, curClass = -1;
  uid_t uid = getuid();
  UserRec ur, ur2;
  int sLeft, sLeft2, tty;
  uid_t guestUID;
  int nLower = 0, systemBusy;
  processConfig();
  tty = devNumFromName(ttyname(STDIN_FILENO) + 5);
  guestUID = UIDfromLogin("guest");
  userList(&nLogins, loginRec);
  procList(&nProcs, procRec);
  systemBusy = maxKick(nProcs, procRec);
  userFileOpen();
  if (lineNo(tty) < 0) goto accept;
  if (!uid && argc == 2) {
    uid = UIDfromLogin(argv[1]);
    if (uid == (uid_t)-1) {
      msg = MSG_DEFAULT;
      goto reject;
    }
  }
  if (uid == guestUID) {
    for (i = 0; i < nLogins && devNumFromName(loginRec[i].tty) != tty; i++);
    if (i == nLogins) {
      msg = MSG_DEFAULT;
      goto reject;
    }
    bzero(&ur, sizeof(UserRec));
    ur.flags = optGuestPriority << 1;
    ur.tLeft = ur.sLeft = optGuestTime - ((time(NULL) - loginRec[i].time) / 60);
    for (i = 0; i < MAX_TIME_CLASSES; i++)
      ur.cLeft[i] = ur.cLimit[i] = -1;
    goto guest;
  }
  if (userFileSearch(&ur, uid)) goto accept;
  curClass = curTimeClass(&ur);
  for (i = 0; i < nLogins; i++)
    if (loginRec[i].uid == uid) {
      j = devNumFromName(loginRec[i].tty);
      if (lineNo(j) < 0) continue;
      if (time(NULL) - loginRec[i].time >= 60) {
	msg = MSG_ALREADY_ONLINE;
	goto reject;
      }
      found++;
    }
  if (!found) {
    msg = MSG_DEFAULT;
    goto reject;
  } else if (found > 1) {
    msg = MSG_ALREADY_ONLINE;
    goto reject;
  }
  if ((!SSMARTBOOT(ur.flags) || systemBusy) && ur.sLeft <= (int)(0.10 * ur.sLimit) && time(NULL) - ur.last < optReturnDelay * 60) {
    msg = MSG_SESSION_WAIT;
    goto reject;
  }
  ur.sLeft = ur.sLimit;
  ur.bSession = 0;
  time(&ur.last);
  userFileEdit(&ur);
guest:
  if (ur.tLimit <= 0) {
    msg = MSG_DEFAULT;
    goto reject;
  }
  if (ur.btLimit && ur.bTotal > ur.btLimit) {
    msg = MSG_DATA_PERIOD;
    goto reject;
  }
  sLeft = INT_MAX;
  if ((!SMARTBOOT(ur.flags) || systemBusy) && ur.tLimit >= 0) sLeft = min(sLeft, ur.tLeft);
  if ((!SSMARTBOOT(ur.flags) || systemBusy) && ur.sLimit >= 0) sLeft = min(sLeft, ur.sLeft);
  if ((!TCSMARTBOOT(ur.flags) || systemBusy) && curClass >= 0 && ur.cLimit[curClass] >= 0)
    sLeft = min(sLeft, ur.cLeft[curClass]);
  if (!PRIORITY(ur.flags) && systemBusy) sLeft = min(sLeft, 0);
  if (sLeft > 0) goto accept;
  if (!optMaxKick) goto reject;
  /*
    If we get this far, then:

      o The user has no time
      o Max-Kick is enabled
    
    The decision is non-trivial -- the user could potentially get booted off the
    system the next time user_updated does an update.  Now a check is done to
    see whether or not that would happen.  If it would happen, we will boot the
    user off now.  There is no point (except perhaps to indulge a warped sense
    of humour) in allowing a user on, only to boot them off in < 60 seconds.  Of
    course, that can still happen despite the most strenuous checking, since
    users may come and go at any time, and user_updated's behaviour is very much
    dependent on utmp's contents...
   */
  rewind(userFile);
  while (!userFileRead(&ur2)) {
    if (ur2.uid == uid) continue;
    for (i = 0; i < nProcs; i++)
      if ((ur2.uid == procRec[i].uid || ur2.uid == procRec[i].euid) &&
          (lineNo(procRec[i].tty) >= 0))
        break;
    if (i == nProcs) continue;
    sLeft2 = INT_MAX;
    if ((!SMARTBOOT(ur2.flags) || systemBusy) && ur2.tLimit >= 0) sLeft2 = min(sLeft2, ur2.tLeft);
    if ((!SSMARTBOOT(ur2.flags) || systemBusy) && ur2.sLimit >= 0) sLeft2 = min(sLeft2, ur2.sLeft);
    if ((!TCSMARTBOOT(ur2.flags) || systemBusy) && curClass >= 0 && ur2.cLimit[curClass] >= 0)
      sLeft2 = min(sLeft2, ur2.cLeft[curClass]);
    if (!PRIORITY(ur2.flags) && systemBusy) sLeft2 = min(sLeft2, -(ur.sLimit - ur.sLeft));
    if (PRIORITY(ur2.flags) < PRIORITY(ur.flags) || (PRIORITY(ur2.flags) == PRIORITY(ur.flags) && sLeft2 < sLeft))
      nLower++;
  }
  for (i = 0; i < nLogins; i++) {
    if (devNumFromName(loginRec[i].tty) == tty) continue;
    if (loginRec[i].uid != guestUID) continue;
    sLeft2 = (optGuestTime * 60 - (time(NULL) - loginRec[i].time)) / 60 + 1;
    if (!optGuestPriority && systemBusy) sLeft2 = min(sLeft2, -(optGuestTime - sLeft2));
    if (optGuestPriority < PRIORITY(ur.flags) || (optGuestPriority == PRIORITY(ur.flags) && sLeft2 < sLeft))
      nLower++;
  }
  if (nLower >= systemBusy) goto accept;;
reject:
  userFileClose();
  if (msg < 0) {
    if (ur.tLeft <= 0) msg = MSG_TIME_PERIOD;
    else if (curClass >= 0 && ur.cLimit[curClass] >= 0 && ur.cLeft[curClass] <= 0) msg = MSG_TIME_CLASS;
    else if (!PRIORITY(ur.flags) && systemBusy) msg = MSG_BUSY;
    else msg = MSG_DEFAULT;
  }
  printFile((char*)msgPath[msg]);
  sleep(2);
  exit(1);
accept:
  userFileClose();
  exit(0);
}

void printFile(char *path) {
  FILE *f = fopen(path, "r");
  char s[256];
  if (!f) perrQuit("fopen");
  printf("\n");
  while (fgets(s, 256, f)) printf(s);
  printf("\n");
  fclose(f);
}
