#include <assert.h>
#include <signal.h>
#include <unistd.h>
#include "common.h"

int		nProcs;
ProcRec		procRec[MAX_PROCS];

void main(int argc, char **argv) {
  int i, nKill = 0;
  pid_t killPID[MAX_PROCS];
  uid_t uid;
  processConfig();
  if (argc != 2) 
    errQuit("usage: user_kick <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  if (!uid)
    errQuit("can't kick root!");
  procList(&nProcs, procRec);
  for (i = 0; i < nProcs; i++) if (procRec[i].uid == uid || procRec[i].euid == uid)
    killPID[nKill++] = procRec[i].pid;
  if (!nKill) exit(0);
  /* buh-bye */
  for (i = 0; i < nKill; i++)
    kill(killPID[i], SIGTERM);
  sleep(5);
  /* which part didn't you understand? the buh? or the bye? */
  for (i = 0; i < nKill; i++)
    kill(killPID[i], SIGKILL);
  printf("user kicked: %s\n", argv[1]);
  exit(0);
}
