#include <pwd.h>
#include <string.h>
#include <sys/wait.h>
#include <unistd.h>
#include <utmp.h>
#include "common.h"

int		userExcluded(uid_t uid);

void main(int argc, char **argv) {
  struct passwd *pw;
  int i, nArgs = 0;
  pid_t pid;
  char login[MAX_LOGINCHARS + 1], *arg[64];
  processConfig();
  if (argc < 2) errQuit("usage: user_foreach <command>");
  arg[nArgs] = argv[1];
  for (i = strlen(arg[nArgs]); i >= 0 && arg[nArgs][i] != '/'; i--);
  if (i >= 0) arg[nArgs] += i + 1;
  nArgs++;
  for (i = 2; i < argc; i++) {
    if (!strcmp(argv[i], "{}")) arg[nArgs++] = login;
    else arg[nArgs++] = argv[i];
  }
  arg[nArgs] = NULL;
  setpwent();
  while ((pw = getpwent()) != NULL) {
    if (userExcluded(pw->pw_uid)) continue;
    strncpy(login, pw->pw_name, MAX_LOGINCHARS);
    login[MAX_LOGINCHARS] = '\0';
    if ((pid = fork()) == 0) {
      execvp(argv[1], arg);
      perrQuit("exec");
    } else if (pid > 0) waitpid(pid, NULL, 0);
    else perrQuit("fork");
  }
  endpwent();
  exit(0);
}

int userExcluded(uid_t uid) {
  int i;
  for (i = 0; i < nExcluded; i++)
    if (excluded[i] == uid) return 1;
  return 0;
}
