#include <time.h>
#include "common.h"

int	userExpire();
int	banExpire();

void main() {
  processConfig();
  while (!userExpire());
  while (!banExpire());
  exit(0);
}

int userExpire() {
  time_t t;
  char login[9];
  UserRec ur;
  userFileOpen();
  time(&t);
  while (!userFileRead(&ur)) {
    if (ur.expire && t >= ur.expire) {
      userFileClose();
      loginFromUID(login, ur.uid);
      if (EXPIRE(ur.flags) == EXPIRE_DELETE)
	runCommand(SBIN"/user_del", login, NULL);
      else
	runCommand(SBIN"/user_unsubscribe", login, NULL);
      return 0;
    }
  }
  userFileClose();
  return 1;
}

int banExpire() {
  time_t t;
  BanRec br;
  char phNo[32];
  banFileOpen();
  time(&t);
  while (!banFileRead(&br)) {
    if (br.expire && t >= br.expire) {
      banFileClose();
      runCommand(SBIN"/user_unban", words2PhNo(phNo, br.phNoArea, br.phNoLocal));
      return 0;
    }
  }
  banFileClose();
  return 1;
}
