#include <string.h>
#include <unistd.h>
#include "common.h"

void	dumpUser(UserRec *ur);

void main(int argc, char **argv) {
  UserRec ur;
  processConfig();
  userFileOpen();
  if (argc > 1) {
    int i;
    for (i = 1; i < argc; i++) {
      uid_t uid = UIDfromLogin(argv[i]);
      if (uid != (uid_t)-1 && !userFileSearch(&ur, uid))
	dumpUser(&ur);
    }
  } else {
    while (!userFileRead(&ur)) {
      dumpUser(&ur);
    }
  }
  userFileClose();
  exit(0);
}

void dumpUser(UserRec *ur) {
  char str[256];
  if (!loginFromUID(str, ur->uid)) return;
  printf("%s ", str);
  if (ur->phNoLocal)
    printf("%s ", words2PhNo(str, ur->phNoArea, ur->phNoLocal));
  else
    printf("N/A ");
  printf("%d ", (int)PRIORITY(ur->flags));
  printf("%d ", ur->tLeft);
  printf("%d ", ur->tLimit);
  printf("%d ", ur->sLimit);
  bytes2ASCII(str, ur->bTotal);
  printf("%s ", str);
  bytes2ASCII(str, ur->btLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bsLimit);
  printf("%s ", str);
  if (ur->expire) {
    if (EXPIRE(ur->flags) == EXPIRE_DELETE) printf("DELETE ");
    else printf("UNSUBSCRIBE ");
  } else printf("N/A ");
  printf("%lu\n", ur->expire);
}
