#include <assert.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/stat.h>
#include "common.h"

void main(int argc, char **argv) {
  int i, n;
  uid_t uid;
  UserRec ur;
  char tUserPath[16];
  FILE *tUserFile;
  processConfig();
  if (argc != 2)
    errQuit("usage: user_delrec <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  strcpy(tUserPath, "/tmp/XXXXXX"); mktemp(tUserPath);
  tUserFile = fopen(tUserPath, "wb"); assert(tUserFile != NULL);
  n = ftell(userFile) / sizeof(UserRec) - 1;
  rewind(userFile);
  for (i = 0; ; i++) {
    if (userFileRead(&ur)) break;
    if (i == n) continue;
    fwrite(&ur, sizeof(UserRec), 1, tUserFile);
  }
  fclose(tUserFile);
  rename(tUserPath, userFilePath); chmod(tUserPath, 0644);
  userFileClose();
  printf("user deleted: %s\n", argv[1]);
  exit(0);
}
