#include <assert.h>
#include <string.h>
#include <unistd.h>
#include "common.h"

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  UserRec ur;
  char login[MAX_LOGINCHARS + 1];
  char str[256], str2[256];
  processConfig();
  if (argc > 2)
    errQuit("usage: user_data [login]");
  if (argc == 1) loginFromUID(login, geteuid());
  else {
    strncpy(login, argv[1], MAX_LOGINCHARS);
    login[MAX_LOGINCHARS] = '\0';
  }
  uid = UIDfromLogin(login);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", login);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", login);
  printf("login:     %s\n", login);
  printf("phone:     ");
  if (ur.phNoLocal) {
    printf("%s\n", words2PhNo(str, ur.phNoArea, ur.phNoLocal));
  } else printf("N/A\n");
  printf("priority:  %d\n", (int)PRIORITY(ur.flags));
  printf("flags:     [ ");
  if (ur.flags & FLG_SMARTBOOT) printf("SMARTBOOT ");
  if (ur.flags & FLG_SSMARTBOOT) printf("SSMARTBOOT ");
  if (ur.flags & FLG_IBOOT) printf("IBOOT ");
  if (ur.flags & FLG_ISMARTBOOT) printf("ISMARTBOOT ");
  if (ur.flags & FLG_TCSMARTBOOT) printf("TCSMARTBOOT ");
  printf("]\n");
  printf("time:      (%d / %d)  (%d / %d)\n", ur.tLeft, ur.tLimit, ur.sLeft, ur.sLimit);
  printf("class:     ");
  for (i = 0; i < MAX_TIME_CLASSES; i++) {
    if (i) printf("  ");
    printf("(%d / %d)", ur.cLeft[i], ur.cLimit[i]);
  }
  printf("\n");
  bytes2ASCII(str, ur.bTotal);
  bytes2ASCII(str2, ur.btLimit);
  printf("data:      (%s / %s)  ", str, str2);
  bytes2ASCII(str, ur.bSession);
  bytes2ASCII(str2, ur.bsLimit);
  printf("(%s / %s)\n", str, str2);
  printf("expiry:    ");
  if (ur.expire) {
    if (EXPIRE(ur.flags) == EXPIRE_DELETE) printf("DELETE");
    else printf("UNSUBSCRIBE");
    strcpy(str, ctime(&ur.expire)); str[strlen(str) - 1] = '\0';
    printf(" in %.2f days [%s]\n", (float)(ur.expire - time(NULL)) / (24 * 60 * 60), str);    
  } else printf("N/A\n");
  strcpy(str, ctime(&ur.last)); str[strlen(str) - 1] = '\0';
  printf("last on:   -%.2f days [%s]\n", (float)(time(NULL) - ur.last) / (24 * 60 * 60), str);
  userFileClose();
  exit(0);
}
