#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "common.h"

void	listBans();

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  UserRec ur;
  BanRec br, br2;
  char phNo[32] = "";
  processConfig();
  br.flags = 0;
  while ((i = getopt(argc, argv, "lp")) != EOF) 
    switch(i) {
    case 'l': listBans(); exit(0);
    case 'p': br.flags = 1;
    }
  if (optind + 1 >= argc)
    errQuit("usage: user_ban [-l] [-p] <expire> <login>|<phone_no>");
  br.expire = addTime(argv[optind++]);
  if (isdigit(argv[optind][0]) || argv[optind][0] == '(') {
    strcpy(phNo, argv[optind]);
    for (i = optind + 1; i < argc; i++) {
      strcat(phNo, " ");
      strcat(phNo, argv[i]);
    }
    if (phNo2Words(&br.phNoArea, &br.phNoLocal, phNo, phNoDigits) ||
	(!br.flags && br.phNoArea && !br.phNoLocal))
      errQuit("invalid phone number: %s", phNo);
  } else {
    uid = UIDfromLogin(argv[optind]);
    if (uid == (uid_t)-1)
      errQuit("user does not exist: %s", argv[optind]);
    userFileOpen();
    if (userFileSearch(&ur, uid))
      errQuit("user not found: %s", argv[optind]);
    userFileClose();
    runCommand(SBIN"/user_del", argv[optind], NULL);
    br.phNoArea = ur.phNoArea; br.phNoLocal = ur.phNoLocal;
  }
  banFileOpen();
  if (!banFileSearch(&br2, br.phNoArea, br.phNoLocal))
    errQuit("phone number is already banned: %s", phNo);
  fseek(banFile, 0, SEEK_END);
  banFileWrite(&br);
  banFileClose();
  if (phNo[0] != '\0') {
    printf("phone number banned: %s", phNo);
    if (br.flags) printf(" (prefix ban)");
    printf("\n");
  } else printf("user banned: %s\n", argv[optind]);
  exit(0);
}

void listBans() {
  char str[256], str2[256];
  BanRec br;
  printf("   Type         Phone No.               Expiry\n"
	 "------------------------------------------------------------------\n");
  banFileOpen();
  while (!banFileRead(&br)) {
    if (br.expire) {
      strcpy(str, ctime(&br.expire)); str[strlen(str) - 1] = '\0';
    } else strcpy(str, "N/A");
    printf("  %-14s%-24s%s\n", br.flags ? "PREFIX" : "NORMAL", words2PhNo(str2, br.phNoArea, br.phNoLocal), str);
  }
  banFileClose();
}

