#include <assert.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "common.h"

int	userFileSearchPhNo(word phNoArea, word phNoLocal);

void main(int argc, char **argv) {
  uid_t uid;
  BanRec br;
  UserRec ur, ur2;
  char phNo[32];
  int i;
  processConfig();
  bzero(&ur, sizeof(UserRec));
  if (argc < 4)
    errQuit("\
usage: user_addrec <login> <expire> <time_limit> [session_limit] [priority]\n\
                   [phone_no] {class_limit}");
  if (argc >= 7) {
    strcpy(phNo, argv[6]);
    if (atoi(phNo) >= 0) {
      if (phNo2Words(&ur.phNoArea, &ur.phNoLocal, phNo, phNoDigits) || (ur.phNoArea && !ur.phNoLocal))
        errQuit("invalid phone number: %s", phNo);
      userFileOpen();
      if (!userFileSearchPhNo(ur.phNoArea, ur.phNoLocal))
        errQuit("phone number is already in use: %s", phNo);
      userFileClose();
      banFileOpen();
      if (!banFileSearch(&br, ur.phNoArea, ur.phNoLocal))
        errQuit("phone number is banned: %s", phNo);
      banFileClose();
    }
  }
  if (isdigit(argv[1][0])) uid = atoi(argv[1]);
  else {
    uid = UIDfromLogin(argv[1]);
    if (uid == (uid_t)-1)
      errQuit("user does not exist: %s", argv[1]);
  }
  userFileOpen();
  if (!userFileSearch(&ur2, uid))
    errQuit("user already exists: %s", argv[1]);
  ur.uid = uid;
  ur.flags = argc >= 6 ? atoi(argv[5]) << 13 : 4 << 13;
  if (optSmartBoot) ur.flags |= FLG_SMARTBOOT;
  if (optSessionSmartBoot) ur.flags |= FLG_SSMARTBOOT;
  if (optIdleBoot) ur.flags |= FLG_IBOOT;
  if (optIdleSmartBoot) ur.flags |= FLG_ISMARTBOOT;
  if (optTimeClassSmartBoot) ur.flags |= FLG_TCSMARTBOOT;
  ur.expire = addTime(argv[2]);
  ur.last = time(NULL);
  ur.tLimit = ur.tLeft = atoi(argv[3]);
  ur.sLimit = ur.sLeft = argc >= 5 ? atoi(argv[4]) : ur.tLimit;
  if (ur.tLimit >= 0 && ur.sLimit > ur.tLimit)
    errQuit("invalid session_limit: %d", ur.sLimit);
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.cLeft[i] = ur.cLimit[i] = -1;
  for (i = 7; i < min(7 + MAX_TIME_CLASSES, argc); i++)
    ur.cLeft[i - 7] = ur.cLimit[i - 7] = atoi(argv[i]);
  fseek(userFile, 0, SEEK_END);
  userFileWrite(&ur);
  userFileClose();
  printf("user added: %s\n", argv[1]);
  exit(0);
}

int userFileSearchPhNo(word phNoArea, word phNoLocal) {
  UserRec ur;
  rewind(userFile);
  while (!userFileRead(&ur))
    if (ur.phNoArea == phNoArea && ur.phNoLocal == phNoLocal)
      return 0;
  return 1;
}
