#include <assert.h>
#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "common.h"

int		nLogins;
LoginRec	loginRec[MAX_USERS];

void main() {
  int i, j, found = 0, curClass;
  char login[MAX_LOGINCHARS + 1], ttyName[16];
  uid_t uid = geteuid();
  UserRec ur;
  dev_t devNo;
  int sLeft = INT_MAX;
  processConfig();
  loginFromUID(login, uid);
  strcpy(ttyName, ttyname(STDIN_FILENO));
  devNo = devNumFromName(ttyName + 5);
  if (lineNo(devNo) < 0) goto l0;
  if (!strcmp(login, "guest")) {
    userList(&nLogins, loginRec);
    for (i = 0; i < nLogins; i++)
      if (!strcmp(ttyName + 5, loginRec[i].tty)) {
	found = 1;
        ur.tLeft = (optGuestTime * 60 - (time(NULL) - loginRec[i].time)) / 60 + 1;
        ur.sLeft = ur.tLeft;
        for (j = 0; j < MAX_TIME_CLASSES; j++)
          ur.cLeft[j] = ur.cLimit[j] = -1;
      }
  } else {
    userFileOpen();
    if (!userFileSearch(&ur, uid)) found = 1;
    userFileClose();
  }
  curClass = curTimeClass(&ur);
  if (found) {
    if (ur.tLimit >= 0) sLeft = min(sLeft, ur.tLeft);
    if (ur.sLimit >= 0) sLeft = min(sLeft, ur.sLeft);
    if (curClass >= 0 && ur.cLimit[curClass] >= 0)
      sLeft = min(sLeft, ur.cLeft[curClass]);
  }
l0:
  if (sLeft == INT_MAX) printf("no time limit!\n");
  else {
    printf("%d minute(s) remaining in this accounting period.\n", ur.tLeft);
    printf("%d minute(s) remaining in this session.\n", sLeft);
  }
  exit(0);
}
