#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <utmp.h>

#define MAX_USERS		256
#define MAX_PROCS		(MAX_USERS * 4)
#define MAX_BOOT_WARN_TIMES	16
#define MAX_TIME_CLASSES       	4
#define MAX_LOGINCHARS		8
#define FLG_PRIORITY		0xe000
#define	FLG_SMARTBOOT		0x1000
#define FLG_SSMARTBOOT		0x0800
#define FLG_IBOOT		0x0400
#define FLG_ISMARTBOOT		0x0200
#define FLG_TCSMARTBOOT		0x0100
#define FLG_EXPIRE		0x0080
#define LOCK_EXCLUSIVE		0
#define LOCK_UNLOCK		1
#define LOCK_BLOCK		2
#define PRIORITY(f)		(((f) & FLG_PRIORITY) >> 13)
#define SMARTBOOT(f)		((f) & FLG_SMARTBOOT)
#define	SSMARTBOOT(f)		((f) & FLG_SSMARTBOOT)
#define IBOOT(f)		((f) & FLG_IBOOT)
#define ISMARTBOOT(f)		((f) & FLG_ISMARTBOOT)
#define TCSMARTBOOT(f)		((f) & FLG_TCSMARTBOOT)
#define EXPIRE(f)		((f) & FLG_EXPIRE)
#define EXPIRE_DELETE		0x0000
#define EXPIRE_UNSUBSCRIBE	0x0080
#define min(x,y)		((x) < (y) ? (x) : (y))
#define max(x,y)		((x) > (y) ? (x) : (y))

typedef unsigned char		byte;
typedef unsigned int		word;
typedef unsigned long long	dword;

typedef struct {
  uid_t		uid				__attribute__ ((packed));
  ushort       	flags				__attribute__ ((packed));
  word		phNoArea			__attribute__ ((packed));
  word		phNoLocal			__attribute__ ((packed));
  int		tLeft				__attribute__ ((packed));
  int		tLimit				__attribute__ ((packed));
  int		sLeft				__attribute__ ((packed));
  int		sLimit				__attribute__ ((packed));
  short		cLeft[MAX_TIME_CLASSES]		__attribute__ ((packed));
  short		cLimit[MAX_TIME_CLASSES]	__attribute__ ((packed));
  dword		bTotal				__attribute__ ((packed));
  dword		btLimit				__attribute__ ((packed));
  dword		bSession       			__attribute__ ((packed));
  dword		bsLimit				__attribute__ ((packed));
  time_t	subExpire			__attribute__ ((packed));
  ushort       	subFlags			__attribute__ ((packed));
  int		subTlimit			__attribute__ ((packed));
  int		subSlimit			__attribute__ ((packed));
  short		subClimit[MAX_TIME_CLASSES]	__attribute__ ((packed));
  dword		subBTlimit			__attribute__ ((packed));
  dword		subBSlimit			__attribute__ ((packed));
  time_t	expire				__attribute__ ((packed));
  time_t	last				__attribute__ ((packed));
} UserRec;	/* sizeof(UserRec) = 122 */

typedef struct {
  byte		flags		__attribute__ ((packed));
  word		phNoArea       	__attribute__ ((packed));
  word		phNoLocal      	__attribute__ ((packed));
  time_t	expire		__attribute__ ((packed));
} BanRec;

typedef struct {
  pid_t		pid;
  uid_t		uid, euid;
  dev_t		tty;
  char		name[16];
} ProcRec;

typedef struct {
  uid_t		uid;
  char		tty[12];
  time_t	time;
} LoginRec;

typedef struct {
  int		startDay, endDay;
  int		startHour, endHour;
} TimeClass;

extern const int	days[12];
extern const char	*configFilePath;
extern const char	*userFilePath;
extern const char	*banFilePath;

extern void		libInit();
extern void		errQuit(char *format, ...);
extern void		perrQuit(char *format, ...);
extern int		devNumFromName(char *devName);
extern int		lineNo(dev_t dev);
extern int		runCommand(char *path, ...);
extern time_t		addTime(char *s);
extern void		procList(int *nProcs, ProcRec *procRec);
extern int		maxKick(int nProcs, ProcRec *procRec);
extern void		userList(int *nLogins, LoginRec *loginRec);
extern int		userLoggedIn(int nLogins, LoginRec *loginRec, uid_t uid);
extern int		getToken(char *d, char *s, int *idx);
extern uid_t		UIDfromLogin(char *login);
extern char		*loginFromUID(char *login, uid_t uid);
extern void		userFileOpen();
extern void		userFileClose();
extern int		userFileRead(UserRec *ur);
extern int		userFileWrite(UserRec *ur);
extern void		userFileEdit(UserRec *ur);
extern int		userFileSearch(UserRec *ur, uid_t uid);
extern void		banFileOpen();
extern void		banFileClose();
extern int		banFileRead(BanRec *br);
extern int		banFileWrite(BanRec *br);
extern int		banFileSearch(BanRec *br, word phNoArea, word phNoLocal);
extern int		phNo2Words(word *phNoArea, word *phNoLocal, char *phNo, int phNoDigits);
extern char		*words2PhNo(char *phNo, word phNoArea, word phNoLocal);
extern int		stringSum(char *s);
extern void		bytes2ASCII(char *str, dword bytes);
extern int		inTimeClass(int tc);
extern int		curTimeClass(UserRec *ur);
extern int		fLock(char *path, int operation);
extern void		processConfig();

extern const char	*configFilePath;
extern const char	*userFilePath;
extern FILE		*userFile;
extern const char	*banFilePath;
extern FILE		*banFile;
extern int		optReturnDelay;
extern int		optSendMail;
extern int		optGuestTime;
extern int		optGuestPriority;
extern int		nBootWarnTimes;
extern int		bootWarnTime[MAX_BOOT_WARN_TIMES];
extern int		optMaxKick;
extern int		optSmartBoot;
extern int		optSessionSmartBoot;
extern int		optIdleBoot;
extern int		optIdleSmartBoot;
extern int		nTimeClasses;
extern TimeClass	timeClass[MAX_TIME_CLASSES];
extern int		optTimeClassSmartBoot;
extern int		nExcluded;
extern uid_t		excluded[64];
extern char		modemDial[64];
extern char		phNoAreaFormat[16];
extern char		phNoLocalFormat[16];
extern int		phNoDigits;
extern int		userFileFD, banFileFD;
extern int		nLines;
extern dev_t		lineDev[MAX_USERS];

#endif
