#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <unistd.h>
#include <utime.h>
#include "common.h"

#define MAX_EXEMPT	MAX_USERS

void			main();
void			processCleanTmpConfig();
void			cleanTmp(char *path);
void			appendSlash(char *s);
int			userExempt(uid_t uid);

int			aTime, cTime, mTime;
int			nPaths ;
int			nExempt;
uid_t			exempt[MAX_EXEMPT];
int			nLogins;
LoginRec		loginRec[MAX_USERS];

void main() {
  userList(&nLogins, loginRec);
  processCleanTmpConfig();
  exit(0);
}

void processCleanTmpConfig() {
  int i, li;
  uid_t uid;
  char line[256], token[256];
  FILE *f;
  if ((f = fopen(LIB"/clean_tmp.config", "rt")) == NULL)
    perrQuit("fopen");
  while (fgets(line, 256, f) != NULL) {
    li = 0;
    if (getToken(token, line, &li)) continue;
    if (!strcasecmp(token, "path") && nPaths < 16) {
      if (getToken(token, line, &li)) continue;
      cleanTmp(token);
    } else if (!strcasecmp(token, "atime")) {
      if (getToken(token, line, &li)) continue;
      aTime = atoi(token) * (24 * 60 * 60);
    } else if (!strcasecmp(token, "ctime")) {
      if (getToken(token, line, &li)) continue;
      cTime = atoi(token) * (24 * 60 * 60);
    } else if (!strcasecmp(token, "mtime")) {
      if (getToken(token, line, &li)) continue;
      mTime = atoi(token) * (24 * 60 * 60);
    } else if (!strcasecmp(token, "exempt")) {
      while (!getToken(token, line, &li) && nExempt < MAX_EXEMPT)
	if ((uid = UIDfromLogin(token)) != (uid_t)-1)
	  exempt[nExempt++] = uid;
    } else if (!strcasecmp(token, "unexempt")) {
      while (!getToken(token, line, &li))
	if ((uid = UIDfromLogin(token)) != (uid_t)-1)
	  for (i = 0; i < nExempt; i++)
	    if (exempt[i] == uid) {
	      exempt[i] = exempt[nExempt - 1];
	      nExempt--;
	    }
    }
  }
  fclose(f);
}

void cleanTmp(char *path) {
  time_t t = time(NULL);
  struct stat _stat;
  int rm;
  char *tpath = (char*) malloc(PATH_MAX + 1);
  DIR *dir = opendir(path);
  struct dirent *_dirent;
  if (dir == NULL) {
    perror("opendir");
    return;
  }
  while ((_dirent = readdir(dir)) != NULL) {
    if (strcmp(_dirent->d_name, ".") && strcmp(_dirent->d_name, "..")) {
      strcpy(tpath, path); appendSlash(tpath); strcat(tpath, _dirent->d_name);
      if (lstat(tpath, &_stat)) continue;
      if (_stat.st_atime > t || _stat.st_ctime > t || _stat.st_mtime > t) {
	utime(tpath, NULL);
	if (lstat(tpath, &_stat)) continue;
      }
      rm = (!userExempt(_stat.st_uid) &&
	    !userLoggedIn(nLogins, loginRec, _stat.st_uid) &&
            t - _stat.st_atime >= aTime &&
            t - _stat.st_ctime >= cTime &&
	    t - _stat.st_mtime >= mTime);
      if (S_ISDIR(_stat.st_mode)) {
        cleanTmp(tpath);
        if (rm)
          rmdir(tpath);
      } else {
        if (rm)
          unlink(tpath);
      }
    }
  }
  closedir(dir);
  free(tpath);
}

void appendSlash(char *s) {
  int len = strlen(s);
  if (s[len - 1] != '/') {
    s[len] = '/';
    s[len + 1] = '\0';
  }
}

int userExempt(uid_t uid) {
  int i;
  for (i = 0; i < nExempt; i++) if (exempt[i] == uid) return 1;
  return 0;
}
