#include <ctype.h>
#include <limits.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <unistd.h>
#include "common.h"

#define		MAX_EXEMPT	64
#define		MAX_KILL	16

void		processCleanProcConfig();
int		cleanProc(int sig);
int		userExempt(uid_t uid);

int		nExempt = 0;
uid_t		exempt[MAX_EXEMPT];
int		nKillName = 0;
char		killName[MAX_KILL][64];
int		nLogins = 0;
LoginRec	loginRec[MAX_USERS];
int		nProcs;
ProcRec		procRec[MAX_PROCS];

void main() {
  processCleanProcConfig();
  userList(&nLogins, loginRec);
  procList(&nProcs, procRec);
  if (cleanProc(SIGTERM)) {
    sleep(5);
    procList(&nProcs, procRec);
    cleanProc(SIGKILL);
  }
  exit(0);
}

void processCleanProcConfig() {
  int li;
  uid_t uid;
  char line[256], token[256];
  FILE *f;
  if ((f = fopen(LIB"/clean_proc.config", "rt")) == NULL)
    perrQuit("fopen");
  while (fgets(line, 256, f) != NULL) {
    li = 0;
    if (getToken(token, line, &li)) continue;
    if (!strcasecmp(token, "exempt")) {
      while (!getToken(token, line, &li) && nExempt < MAX_EXEMPT)
	if ((uid = UIDfromLogin(token)) != (uid_t)-1)
	  exempt[nExempt++] = uid;
    } else if (!strcasecmp(token, "kill")) {
      while (!getToken(token, line, &li) && nKillName < MAX_KILL)
	strcpy(killName[nKillName++], token);
    }
  }
  fclose(f);
}

int cleanProc(int sig) {
  int found, i, j, nKill = 0;
  pid_t killPID[MAX_PROCS];
  for (i = 0; i < nProcs; i++) {
    if (procRec[i].tty) continue;
    for (found = 0, j = 0; j < nKillName; j++)
      if (!strcmp(killName[j], procRec[i].name)) found = 1;
    if (found || (!userExempt(procRec[i].uid) && !userLoggedIn(nLogins, loginRec, procRec[i].uid)))
      killPID[nKill++] = procRec[i].pid;
  }
  for (i = 0; i < nKill; i++) kill(killPID[i], sig);
  return nKill;
}

int userExempt(uid_t uid) {
  int i;
  for (i = 0; i < nExempt; i++) if (exempt[i] == uid) return 1;
  return 0;
}
