/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

int				myexit(status)
int				status;
{
#ifdef DEBUG_MALLOC
  fprintf(stderr,"\n--\n");
  debug_malloc_status(0);
  debug_malloc_destroy();
#endif  
  exit(status);
}

int				main()
{
  t_bufferize_context		bc;
  t_status			status;
  char				buf[42];
  
  more_verbose = TRUE;
#ifdef DEBUG_MALLOC
  debug_malloc_init();
#endif
  bc.fd = 0;
  bc.buf = buf;
  bc.buflen = sizeof (buf);
  if ((status = bufferize_init(&bc)) < 0)
    {
      err_print(-status,"bufferize_init");
      myexit(1);
    }
  while (1)
    {
      char			*str;

      if ((str = get_next_line(&bc,&status)) == NULL)
	{
	  if (status == 0)
	    {
	      if (VEC_COUNT(bc.vec_buf) != 0)
		{
		  fprintf(stderr,"garbage:\n");
		  vec_buf_print(bc.vec_buf);
		}
	      bufferize_destroy(&bc);
	      myexit(0);
	    }
	  err_print(-status,"get_next_line");
	  myexit(1);
	}
      printf("`%s'\n",str);
      bc.vec_buf->free_proc(str,"str");
    }
}


