/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <fcntl.h>
#include "fcache.h"
#include "ns_ml.h"

t_dict			*ns_ml_dict = NULL;

t_status		ns_ml_init(VOID_DECL)
{
  t_status		status;

  if ((ns_ml_dict = NS_DICT_NEW(&status)) == NULL)
    {
      err_print(-status,"NS_DICT_NEW");
      return (status);
    }
  return (0);
}

t_status		ns_ml_destroy_dict(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  t_vec			*vec;
  t_status		status;

  vec = (t_vec *)(he->value);
  VEC_FOR(vec,t_vec *vec_str)
    {
      vec_str_delete(vec_str);
    }
  VEC_ENDFOR;
  vec_delete(vec);
  return (status);
}

VOID_FUNC		ns_ml_destroy(VOID_DECL)
{
  dict_walk(ns_ml_dict,
	    (t_dict_walk_proc)ns_ml_destroy_dict,
	    NULL);
  dict_delete(ns_ml_dict);
}

t_vec			*ns_ml_load(fname,status)
char			*fname;
t_status		*status;
{
  int			fd;
  t_parse_lines_context	plc;
  char			wordbuf[STR_BUFSIZ];

  if (verbose)
    {
      fprintf(stderr,"loading db %s\n",fname);
    }
  if ((fd = open(fname,O_RDONLY)) < 0)
    {
      (*status) = -ERR_OPEN;
      err_print(-(*status),"opening db %s",fname);
      return (NULL);
    }
  if ((plc.vec = NS_VEC_NEW(status)) == NULL)
    {      
      close(fd);
      return (NULL);
    }
  plc.wordbuf = wordbuf;
  plc.wordbuflen = sizeof (wordbuf);
  plc.wordseps = " \t";
  plc.lineseps = "\n";
  parse_lines_init(&plc);
  while (1)
    {
      char		buf[BUFSIZ];
      int		cc;
      
      if ((cc = read(fd,buf,sizeof (buf))) < 0)
	{
	  (*status) = -ERR_READ;
	  break ;
	}
      if (cc == 0)
	{
	  (*status) = 0;
	  break ;
	}
      if (((*status) = parse_lines(&plc,buf,cc)) < 0)
	{
	  break ;
	}
    }
  if (((*status) = parse_lines_finnish(&plc)) < 0)
   goto bad;
  if (((*status) = dict_add(ns_ml_dict,fname,plc.vec)) < 0)
    goto bad;
  close(fd);
  if (verbose)
    {
      fprintf(stderr,"successfully loaded ml %s (%d records)\n",
	      fname,VEC_COUNT(plc.vec));
    }
  return (plc.vec);
bad:
  VEC_FOR(plc.vec,t_vec *vec_str)
    {
      vec_str_delete(vec_str);
    }
  VEC_ENDFOR;
  vec_delete(plc.vec);
  close(fd);
  return (NULL);  
}

t_vec			*ns_ml_open(fname,status)
char			*fname;
t_status		*status;
{
  t_hash_elt		*he;

  if (he = dict_get(ns_ml_dict,fname))
    return ((t_vec *)(he->value));
  else
    return (ns_ml_load(fname,status));
}

char			*ns_ml_get(fname,key,field,status)
char			*fname;
char			*key;
int			field;
t_status		*status;
{
  t_vec			*vec;

  if ((vec = ns_ml_open(fname,status)) == NULL)
    return (NULL);
  VEC_FOR(vec,t_vec *vec_str)
    {
      if (gmatch(key,VEC_AT(vec_str,0)))
	{
	  if (field > (VEC_COUNT(vec_str) - 1))
	    {
	      (*status) = -ERR_NOSUCHFIELD;
	      return (NULL);
	    }
	  else
	    return (VEC_AT(vec_str,field));
	}
    }
  VEC_ENDFOR;
  (*status) = -ERR_NOMATCH;
  return (NULL);
}
