/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <fcntl.h>
#include "fcache.h"
#include "ns_db.h"

t_dict			*ns_db_dict = NULL;

t_status		ns_db_init(VOID_DECL)
{
  t_status		status;

  if ((ns_db_dict = NS_DICT_NEW(&status)) == NULL)
    {
      err_print(-status,"NS_DICT_NEW");
      return (status);
    }
  return (0);
}

t_status		ns_db_destroy_vec_str(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  t_vec			*vec_str;

  vec_str = (t_vec *)(he->value);
  vec_str_delete(vec_str);
  return (0);
}

t_status		ns_db_destroy_dict(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  t_dict		*dict;
  t_status		status;

  dict = (t_dict *)(he->value);
  status = dict_walk(dict,
		     (t_dict_walk_proc)ns_db_destroy_vec_str,
		     NULL);
  dict_delete(dict);
  return (status);
}

VOID_FUNC		ns_db_destroy(VOID_DECL)
{
  dict_walk(ns_db_dict,
	    (t_dict_walk_proc)ns_db_destroy_dict,
	    NULL);
  dict_delete(ns_db_dict);
}

t_dict			*ns_db_load(fname,status)
char			*fname;
t_status		*status;
{
  int			fd;
  t_parse_lines_context	plc;
  char			wordbuf[STR_BUFSIZ];
  t_dict		*dict;

  if (verbose)
    {
      fprintf(stderr,"loading db %s\n",fname);
    }
  if ((fd = open(fname,O_RDONLY)) < 0)
    {
      (*status) = -ERR_OPEN;
      err_print(-(*status),"opening db %s",fname);
      return (NULL);
    }
  if ((plc.vec = NS_VEC_NEW(status)) == NULL)
    {      
      close(fd);
      return (NULL);
    }
  plc.wordbuf = wordbuf;
  plc.wordbuflen = sizeof (wordbuf);
  plc.wordseps = " \t";
  plc.lineseps = "\n";
  parse_lines_init(&plc);
  while (1)
    {
      char		buf[BUFSIZ];
      int		cc;
      
      if ((cc = read(fd,buf,sizeof (buf))) < 0)
	{
	  (*status) = -ERR_READ;
	  break ;
	}
      if (cc == 0)
	{
	  (*status) = 0;
	  break ;
	}
      if (((*status) = parse_lines(&plc,buf,cc)) < 0)
	{
	  break ;
	}
    }
  if (((*status) = parse_lines_finnish(&plc)) < 0)
   goto bad;
  if ((dict = NS_DICT_NEW(status)) == NULL)
    return (NULL);
  VEC_FOR(plc.vec,t_vec *vec_str)
    {
      if (((*status) = dict_add(dict,VEC_AT(vec_str,0),vec_str)) < 0)
	{
	  dict_delete(dict);
	  goto bad;
	}
    }
  VEC_ENDFOR;
  if (((*status) = dict_add(ns_db_dict,fname,dict)) < 0)
    goto bad;
  vec_delete(plc.vec);
  close(fd);
  if (verbose)
    {
      fprintf(stderr,"successfully loaded db %s (%d records)\n",
	      fname,dict_count(dict));
    }
  return (dict);
bad:
  VEC_FOR(plc.vec,t_vec *vec_str)
    {
      vec_str_delete(vec_str);
    }
  VEC_ENDFOR;
  vec_delete(plc.vec);
  close(fd);
  return (NULL);  
}

t_dict			*ns_db_open(fname,status)
char			*fname;
t_status		*status;
{
  t_hash_elt		*he;

  if (he = dict_get(ns_db_dict,fname))
    return ((t_dict *)(he->value));
  else
    return (ns_db_load(fname,status));
}

char			*ns_db_get(fname,key,field,status)
char			*fname;
char			*key;
int			field;
t_status		*status;
{
  t_dict		*dict;
  t_hash_elt		*he;

  if ((dict = ns_db_open(fname,status)) == NULL)
    return (NULL);
  if (he = dict_get(dict,key))
    {
      t_vec		*vec;

      vec = (t_vec *)(he->value);
      if (field > (VEC_COUNT(vec) - 1))
	{
	  (*status) = -ERR_NOSUCHFIELD;
	  return (NULL);
	}
      else
	return (VEC_AT(vec,field));
    }
  (*status) = -ERR_NOSUCHKEY;
  return (NULL);
}
