/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef NS_EXP_H
#define NS_EXP_H	1

#include "a.h"
#include "exp_object.h"
#include "exp_class.h"
#include "exp_compil.h"

struct s_rule;

typedef struct		s_ns_exp
{
  t_object_manager	*om;
  t_class_manager	*cm;
  t_compil		*compil;
  int			void_oid;
  int			int_oid;
  int			str_oid;
  struct s_rule		*rule;
} t_ns_exp;

/* PROTO ns_exp.c */
/* ns_exp.c */
t_status func_echo P((t_token *token, t_node *node, t_object **result));
t_status func_keepdict_count P((t_token *token, t_node *node, t_object **result));
t_status func_format P((t_token *token, t_node *node, t_object **result));
t_status func_db_get P((t_token *token, t_node *node, t_object **result));
void ns_exp_init P((t_ns_exp *ns_exp));
void ns_exp_destroy P((t_ns_exp *ns_exp));
void ns_exp_show P((t_ns_exp *ns_exp));
#endif
