/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef FCACHE_H
#define FCACHE_H	1

#include "netsentry.h"

typedef FILE		*(*t_fopen_proc) P((char *fname));
typedef VOID_FUNC	(*t_fclose_proc) P((FILE *f));

typedef struct		s_file_cache
{
  t_dict		*dict;
  t_fopen_proc		fopen_proc;
  t_fclose_proc		fclose_proc;
} t_file_cache;

/* PROTO fcache.c */
/* fcache.c */
FILE *file_cache_open P((t_file_cache *fc, char *fname, t_status *status));
t_status file_cache_close_cb P((t_hash_elt *he, t_file_cache *fc));
t_status file_cache_close P((t_file_cache *fc));
t_status file_cache_flush_cb P((t_hash_elt *he, t_file_cache *fc));
t_status file_cache_flush P((t_file_cache *fc));
#endif
