/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef CF_H
#define CF_H	1

#include "netsentry.h"

#define RULES_STR		"rules"
#define DEFAULT_STR		"default"
#define PREFIXES_STR		"prefixes"
#define DATABASES_STR		"databases"
#define MATCHLISTS_STR		"matchlists"
#define FILTER_STR		".filter"
#define ACTION_STR		".action"
#define MAXFAILS_STR		".maxfails"
#define CONT_STR		".cont"
#define MAXKEEP_STR		".maxkeep"
#define EXP_STR			".exp"

#define MAXFAILS		256
#define MAXKEEP			256

typedef t_status	(*t_cmd_proc) P((t_vec *args,
					 char *buf,
					 int len,
					 int caplen,
					 struct timeval *ts,
					 pcap_t *pcap,
					 t_rule *rule,
					 VOID_PTR data));

typedef struct		s_compiled_cmd
{
  t_cmd_proc		cmd_proc;
  VOID_PTR		data;
} t_compiled_cmd;

typedef t_status	(*t_cmd_init_proc) P((t_vec *args,
					      t_compiled_cmd *cc));
					      
/* PROTO cf.c */
/* cf.c */
t_dict *open_cf P((void));
t_vec *get_rules_names P((t_dict *vars));
t_vec *get_prefixes_names P((t_dict *vars));
t_vec *get_databases_names P((t_dict *vars));
t_vec *get_matchlists_names P((t_dict *vars));
t_vec *get_cmds P((char *str));
t_vec *compile_cmds P((t_vec *cmds));
t_rule *compile_rule P((pcap_t *pcap, t_dict *vars, char *name));
void show_rules P((t_vec *rules));
t_rule *rule_get_from_name P((t_vec *rules, char *name));
t_status init_things_for_cmds P((void));
void rule_destroy P((t_rule *rule));
void delete_rules P((t_vec *rules));
#endif
