/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "netsentry.h"

extern t_boolean	resolve;
extern t_file_cache	file_cache_aplus;

t_status		cmd_format(args,buf,len,caplen,ts,pcap,rule,data)
t_vec			*args;
char			*buf;
int			caplen;
int			len;
struct timeval		*ts;
pcap_t			*pcap;
t_rule			*rule;
VOID_PTR		data;
{
  t_status		status;
  char			str[BUFSIZ];
  t_pkt			pkt;
  FILE			*f;

  str[0] = 0;
  if ((status = pkt_get(buf,len,caplen,ts,pcap,&pkt)) < 0)
    return (status);
  if ((status = pkt_format(&pkt,
			   VEC_AT(args,1),
			   rule->gc->prefixes,
			   str,
			   sizeof (str))) < 0)
    return (status);
  if (VEC_COUNT(args) == 3)
    {
      char		fname[MAXPATHLEN + 1];

      fname[0] = 0;
      if ((status = pkt_format(&pkt,
			       VEC_AT(args,2),
			       rule->gc->prefixes,
			       fname,
			       sizeof (fname))) < 0)
	return (status);
      if ((f = file_cache_open(&file_cache_aplus,
			       fname,
			       &status)) == NULL)
	return (status);
    }
  else
    f = stdout;
  fprintf(f,"%s\n",str);
  return (0);
}

t_status		cmd_format_init(args,cc)
t_vec			*args;
t_compiled_cmd		*cc;
{
  t_status		status;

  if (VEC_COUNT(args) != 3 && VEC_COUNT(args) != 2)
    {
      err_print(ERR_BADARGS,"syntax: format format [format_file]");
      return (-1);
    }
  cc->cmd_proc = cmd_format;
  return (0);
}
