/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "typ_tcpflags.h"
#include "lay_tcp.h"
#include "layeri.h"

t_mask_def		tcp_flags_defs[] = 
{
  {"fin",		TH_FIN},
  {"syn",		TH_SYN},
  {"rst",		TH_RST},
  {"push",		TH_PUSH},
  {"ack",		TH_ACK},
  {"urg",		TH_URG},
  {NULL,		0}
};

t_status		tcpflags_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "tcpflags";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned char	tcpflags;
	
	if (ed->b.len < sizeof (tcpflags))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&tcpflags),sizeof (tcpflags));
	return (mask_to_str(tcp_flags_defs,
			    tcpflags,
			    "|",
			    bs->str,
			    bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	unsigned char	tcpflags;
	t_status	status;
	t_vec		*vec_str;
	t_mask		mask;
	
	if (ed->b.len < sizeof (tcpflags))
	  return (-ERR_TRUNC);
	if ((vec_str = LAYER_VEC_NEW(&status)) == NULL)
	  return (status);
	if ((status = vec_str_split(vec_str,str,'|')) < 0)
	  {
	    vec_str_delete(vec_str);
	    return (status);
	  }
	mask = 0;
	if ((status = mask_from_vec_str(tcp_flags_defs,
					vec_str,
					&mask)) < 0)
	  {
	    vec_str_delete(vec_str);
	    return (status);
	  }
	tcpflags = mask;
	bcopy((char *)(&tcpflags),ed->b.buf,sizeof (tcpflags));
	vec_str_delete(vec_str);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
