/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "layeri.h"
#include "typ_long.h"

t_status		nlong_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "nlong";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_32		l;

	if (ed->b.len < LONG_LEN)
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&l),LONG_LEN);
	l = ntohl(l);
	return (int_to_str((int)l,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_32		l;
	t_status	status;	

	if (ed->b.len < LONG_LEN)
	  return (-ERR_TRUNC);
	l = htonl(strtol(str,NULL,10));
	bcopy((char *)(&l),ed->b.buf,LONG_LEN);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	

t_status		nulong_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "nulong";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u32		l;

	if (ed->b.len < LONG_LEN)
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&l),LONG_LEN);
	l = ntohl(l);
	return (uint_to_str((unsigned int)l,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_u32		l;
	t_status	status;	

	if (ed->b.len < LONG_LEN)
	  return (-ERR_TRUNC);
	l = htonl(strtoul(str,NULL,10));
	bcopy((char *)(&l),ed->b.buf,LONG_LEN);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
