/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "layeri.h"
#include "typ_iptos.h"

/*
TOS Value       Description                             Reference
---------       --------------------------              ---------
  0000          Default                                 [RFC1349]
  0001          Minimize Monetary Cost                  [RFC1349]
  0010          Maximize Reliability                    [RFC1349]
  0100          Maximize Throughput                     [RFC1349]
  1000          Minimize Delay                          [RFC1349]
  1111          Maximize Security                       [RFC1455]
  */

t_assoc			iptos_assocs[] = 
{
  {"default",			(VOID_PTR)0x0},
  {"minimize_monetary_cost",	(VOID_PTR)0x1},
  {"maximize_reliability",	(VOID_PTR)0x2},
  {"maximize_throughput",	(VOID_PTR)0x4},
  {"minimize_delay",		(VOID_PTR)0x8},
  {"maximize_security",		(VOID_PTR)0x17},
  {NULL,		NULL}
};

t_status		iptos_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "iptos";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned char	iptos;
	t_assoc		*assoc;

	if (ed->b.len < sizeof (iptos))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&iptos),sizeof (iptos));
	if ((assoc = assoc_str_int_from_right(iptos_assocs,iptos)) == NULL)
	  return (ucharint_msg(msg,arg1,arg2));
	else
	  return (str_cat_str(bs->str,bs->max_len,assoc->left));
      }
    }
  return (-ERR_NOMETHOD);
}	
