/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "layeri.h"
#include "typ_icmptype.h"

/*
Type    Name                                    Reference
----    -------------------------               ---------
  0     Echo Reply                               [RFC792]
  1     Unassigned                                  [JBP]
  2     Unassigned                                  [JBP]
  3     Destination Unreachable                  [RFC792]
  4     Source Quench                            [RFC792]
  5     Redirect                                 [RFC792]
  6     Alternate Host Address                      [JBP]
  7     Unassigned                                  [JBP]
  8     Echo                                     [RFC792]
  9     Router Advertisement                    [RFC1256]
 10     Router Selection                        [RFC1256]
 11     Time Exceeded                            [RFC792]
 12     Parameter Problem                        [RFC792]
 13     Timestamp                                [RFC792]
 14     Timestamp Reply                          [RFC792]
 15     Information Request                      [RFC792]
 16     Information Reply                        [RFC792]
 17     Address Mask Request                     [RFC950]
 18     Address Mask Reply                       [RFC950]
 19     Reserved (for Security)                    [Solo]
 20-29  Reserved (for Robustness Experiment)        [ZSu]
 30     Traceroute                              [RFC1393]
 31     Datagram Conversion Error               [RFC1475]
 32     Mobile Host Redirect              [David Johnson]
 33     IPv6 Where-Are-You                 [Bill Simpson]
 34     IPv6 I-Am-Here                     [Bill Simpson]
 35     Mobile Registration Request        [Bill Simpson]
 36     Mobile Registration Reply          [Bill Simpson]
 37-255 Reserved                                    [JBP]
 */

t_assoc				icmptype_assocs[] =
{
  {"echo_reply",		(VOID_PTR)0},
  {"unreachable",		(VOID_PTR)3},
  {"source_quench",		(VOID_PTR)4},
  {"redirect",			(VOID_PTR)5},
  {"alternate_host_address",	(VOID_PTR)6},
  {"echo_request",		(VOID_PTR)8},
  {"router_advertisement",	(VOID_PTR)9},
  {"router_selection",		(VOID_PTR)10},
  {"time_exceed",		(VOID_PTR)11},
  {"parameter_problem",		(VOID_PTR)12},
  {"timestamp",			(VOID_PTR)13},
  {"timestamp_reply",		(VOID_PTR)14},
  {"info_request",		(VOID_PTR)15},
  {"info_reply",		(VOID_PTR)16},
  {"mask_request",		(VOID_PTR)17},
  {"mask_reply",		(VOID_PTR)18},
  {"traceroute",		(VOID_PTR)30},
  {"datagram_conversion_error",	(VOID_PTR)31},
  {"mobile_host_redirect",	(VOID_PTR)32},
  {"ipv6_where_are_you",	(VOID_PTR)33},
  {"ipv6_i_am_here",		(VOID_PTR)34},
  {"mobile_regist_request",	(VOID_PTR)35},
  {"mobile_regist_reply",	(VOID_PTR)36},
  {NULL,			NULL},
};

t_status		icmptype_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "icmptype";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned short	icmptype;
	t_assoc		*assoc;

	if (ed->b.len < sizeof (icmptype))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&icmptype),sizeof (icmptype));
	if ((assoc = assoc_str_int_from_right(icmptype_assocs,
					      icmptype)) == NULL)
	  return (nushort_msg(msg,arg1,arg2));
	else
	  return (str_cat_str(bs->str,bs->max_len,assoc->left));
      }
    }
  return (-ERR_NOMETHOD);
}	
