/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "typ_char.h"
#include "layeri.h"

t_status		char_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
		
	(*name) = "char";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	char		c;

	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&c),sizeof (char));
	return (str_cat_char(bs->str,bs->max_len,c));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
		
	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	if (strlen(str) != 1)
	  return (-ERR_INVAL);
	bcopy(str,ed->b.buf,sizeof (char));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	

t_status		charbit_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
		
	(*name) = "charbit";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned char	c;
	unsigned int	flag;

	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&c),sizeof (char));
	flag = (unsigned int)(ed->data);
	if (flag == CHARBIT_0F)
	  c &= 0x0f;
	else
	  if (flag == CHARBIT_F0)
	    c >>= 4;
	  else
	    return (-ERR_NI);
	return (uint_to_str((unsigned int)c,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	return (-ERR_NI);
      }
    }
  return (-ERR_NOMETHOD);
}	

t_status		charint_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "charint";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	char		c;

	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&c),sizeof (char));
	return (int_to_str((int)c,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	char		c;

	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	c = atoi(str);
	bcopy((char *)(&c),ed->b.buf,sizeof (char));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	

t_status		ucharint_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "charint";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned char	c;

	if (ed->b.len < sizeof (char))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&c),sizeof (char));
	return (uint_to_str((unsigned int)c,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	return (charint_msg(msg,arg1,arg2));
      }
    }
  return (-ERR_NOMETHOD);
}	
