/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "miscinet.h"
#include "pkt.h"

t_status		pkt_sub(pkt,sub_pkt)
t_pkt			*pkt;
t_pkt			*sub_pkt;
{
  t_status		status;
  t_buf			b;
  t_msg_proc		sub_mp;
  off_t			off;

  b.buf = pkt->buf;
  b.len = pkt->len;
  if ((status = lay_msg(pkt->mp,
			LAY_SUB,
			&b,
			&sub_mp)) < 0)
    return (status);
  sub_pkt->mp = sub_mp;
  if ((status = lay_msg(pkt->mp,
			LAY_OFF,
			&b,
			&off)) < 0)
    return (status);
  sub_pkt->buf = pkt->buf + off;
  sub_pkt->len = pkt->len - off;
  sub_pkt->netlen = pkt->netlen;
  sub_pkt->ts = pkt->ts;
  return (0);
}

t_status		pkt_subn(pkt,subn_pkt,desired_mp)
t_pkt			*pkt;
t_pkt			*subn_pkt;
t_msg_proc		desired_mp;
{
  t_msg_proc		sub_mp;
  t_status		status;

  if (pkt->mp == desired_mp)
    {
      PKT_COPY(pkt,subn_pkt);
      return (0);
    }
  if ((status = pkt_sub(pkt,subn_pkt)) < 0)
    return (status);
  else
    {
      t_pkt		tmp_pkt;

      PKT_COPY(subn_pkt,&tmp_pkt);
      return (pkt_subn(&tmp_pkt,subn_pkt,desired_mp));
    }
}

t_status		pkt_sum(pkt,up_pkt)
t_pkt			*pkt;
t_pkt			*up_pkt;
{
  t_pkt			sub_pkt;
  t_status		status;

  if ((status = pkt_sub(pkt,&sub_pkt)) < 0)
    {
      if (status != -ERR_NOMETHOD)
	return (status);
      else
	return (0);
    }
  else
    {
      t_pkt		tmp_pkt;
      t_sum_data	sd;

      PKT_COPY(pkt,&tmp_pkt);
      if ((status = pkt_sum(&sub_pkt,&tmp_pkt)) < 0)
	{
	  if (status != -ERR_NOMETHOD)
	    return (status);
	}
      if (!up_pkt)
	up_pkt = pkt;
      sd.b.buf = pkt->buf;
      sd.b.len = pkt->len;
      sd.up.buf = up_pkt->buf;
      sd.up.len = up_pkt->len;
      if ((status = lay_msg(pkt->mp,
			    LAY_SUM,
			    &sd,
			    NULL)) < 0)
	{
	  if (status != -ERR_NOMETHOD)
	    return (status);
	}
      return (0);
    }
}

t_status		pkt_get_field_to_str(pkt,field,str,max_len)
t_pkt			*pkt;
char			*field;
char			*str;
int			max_len;
{
  t_status		status;
  char			*layer;
  int			layerlen;
  t_pkt			sub_pkt;
  t_pkt			tmp_pkt;
  t_bridled_str		bs;
  t_get_field_data	gfd;

  layer = field;
  if ((field = index(layer,'.')) == NULL)
    {
      gfd.field = layer;
      gfd.b.buf = pkt->buf;
      gfd.b.len = pkt->len;
      bs.str = str;
      bs.max_len = max_len;
      return (lay_msg(pkt->mp,
		      LAY_GET_FIELD,
		      &gfd,
		      &bs));
    }
  layerlen = field - layer;
  field++;
  PKT_COPY(pkt,&sub_pkt);
  do 
    {
      char		*name;
      
      if ((status = lay_msg(sub_pkt.mp,
			    LAY_NAME,
			    NULL,
			    &name)) < 0)
	return (status);
      if (!strncmp(layer,name,layerlen))
	{
	  gfd.field = field;
	  gfd.b.buf = sub_pkt.buf;
	  gfd.b.len = sub_pkt.len;
	  bs.str = str;
	  bs.max_len = max_len;
	  return (lay_msg(sub_pkt.mp,
			  LAY_GET_FIELD,
			  &gfd,
			  &bs));
	}
      PKT_COPY(&sub_pkt,&tmp_pkt);
    } while (pkt_sub(&tmp_pkt,&sub_pkt) == 0);
  return (-ERR_NOENT);
}

t_status		pkt_set_field_from_str(pkt,field,str)
t_pkt			*pkt;
char			*field;
char			*str;
{
  t_status		status;
  char			*layer;
  t_pkt			sub_pkt;
  t_pkt			tmp_pkt;
  t_get_field_data	gfd;
  int			layerlen;

  layer = field;
  if ((field = index(layer,'.')) == NULL)
    {
      gfd.field = layer;
      gfd.b.buf = pkt->buf;
      gfd.b.len = pkt->len;
      return (lay_msg(pkt->mp,
		      LAY_SET_FIELD,
		      &gfd,
		      str));
    }
  layerlen = field - layer;
  field++;
  PKT_COPY(pkt,&sub_pkt);
  do 
    {
      char		*name;
      
      if ((status = lay_msg(sub_pkt.mp,
			    LAY_NAME,
			    NULL,
			    &name)) < 0)
	return (status);
      if (!strncmp(layer,name,layerlen))
	{
	  gfd.field = field;
	  gfd.b.buf = sub_pkt.buf;
	  gfd.b.len = sub_pkt.len;
	  return (lay_msg(sub_pkt.mp,
			  LAY_SET_FIELD,
			  &gfd,
			  str));
	}
      PKT_COPY(&sub_pkt,&tmp_pkt);
    } while (pkt_sub(&tmp_pkt,&sub_pkt) == 0);
  return (-ERR_NOENT);
}

static int		thiszone;

/* FROM TCPDUMP */
t_status		timeval_to_str(tv,str,max_len,resolve)
struct timeval		*tv;
char			*str;
int			max_len;
t_boolean		resolve;
{
  t_status		status;
  
  if (resolve)
    {
      unsigned int	s;
      
      s = (tv->tv_sec + thiszone) % 86400;
      return (str_cat_fmt_va(str,
			     max_len,
			     "%02u:%02u:%02u.%06u",
			     s / 3600,
			     (s % 3600) / 60,
			     s % 60,
			     (unsigned int)(tv->tv_usec)));
    }
  else
    return (str_cat_fmt_va(str,
			   max_len,
			   "%u.%06u",
			   (unsigned int)(tv->tv_sec),
			   (unsigned int)(tv->tv_usec)));
}

t_status		timeval_to_str_init(VOID_DECL)
{
  thiszone = gmt2local(0);
  return (0);
}

/* TO IMPROVE */
t_status		local_to_str(pkt,prefixes,str,max_len,remote,resolve)
t_pkt			*pkt;
t_vec			*prefixes;
char			*str;
int			max_len;
t_boolean		remote;
t_boolean		resolve;
{
  char			src[STR_BUFSIZ];
  char			dst[STR_BUFSIZ];
  struct in_addr	inaddrsrc;
  struct in_addr	inaddrdst;
  t_boolean		srcislocal;
  t_boolean		dstislocal;
  struct in_addr	*wantedinaddr;
  t_status		status;

  src[0] = 0;
  if ((status = pkt_get_field_to_str(pkt,
				     "ip.src",
				     src,
				     sizeof (src))) < 0)
      return (status);
  dst[0] = 0;
  if ((status = pkt_get_field_to_str(pkt,
				     "ip.dst",
				     dst,
				     sizeof (dst))) < 0)
      return (status);
  if ((status = inaddr_from_str(src,&inaddrsrc,FALSE)) < 0)
    return (status);
  if ((status = inaddr_from_str(dst,&inaddrdst,FALSE)) < 0)
    return (status);
  srcislocal = FALSE;
  VEC_FOR(prefixes,t_subnet *subnet)
    {
      if (is_subnet_member(&inaddrsrc,subnet))
	{
	  srcislocal = TRUE;
	  break ;
	}
    }
  VEC_ENDFOR;
  dstislocal = FALSE;
  VEC_FOR(prefixes,t_subnet *subnet)
    {
      if (is_subnet_member(&inaddrdst,subnet))
	{
	  dstislocal = TRUE;
	  break ;
	}
    }
  VEC_ENDFOR;
#define REMOTESRC	(remote?&inaddrdst:&inaddrsrc)
#define REMOTEDST	(remote?&inaddrsrc:&inaddrdst)
  if (srcislocal != dstislocal)
    wantedinaddr = srcislocal?REMOTESRC:REMOTEDST;
  else
    wantedinaddr = (inaddr_cmp(&inaddrsrc,&inaddrdst) < 0)?REMOTESRC:REMOTEDST;
  return (inaddr_to_str(wantedinaddr,
			str,
			max_len,
			resolve));
}

t_status		pkt_format_do(bs,var,pfdd)
t_bridled_str		*bs;
char			*var;
t_pkt_format_do_data	*pfdd;
{
  int			varlen;
  long			signedvalue;
  t_status		status;

  varlen = strlen(var);
  if (varlen == 0)
    return (str_cat_char(bs->str,bs->max_len,'%'));
  else
    if (isdigit(var[0]))
      {
	if (var[0] == '0')
	  {
	    if (var[1] == 'x' || var[1] == 'X')
	      signedvalue = strtol(var,NULL,16);
	    else
	      signedvalue = strtol(var,NULL,8);
	  }
	else
	  signedvalue = strtol(var,NULL,10);
	return (str_cat_char(bs->str,bs->max_len,(int)signedvalue));
      }
    else
      {
	if (!strcmp(var,"date") || !strcmp(var,"Date"))
	  return (timeval_to_str(&(pfdd->pkt->ts),
				 bs->str,
				 bs->max_len,
				 var[0] == 'D'));
	if (!strcmp(var,"local") || !strcmp(var,"Local"))
	  return (local_to_str(pfdd->pkt,
			       pfdd->prefixes,
			       bs->str,
			       bs->max_len,
			       FALSE,
			       var[0] == 'L'));
	if (!strcmp(var,"remote") || !strcmp(var,"Remote"))
	  return (local_to_str(pfdd->pkt,
			       pfdd->prefixes,
			       bs->str,
			       bs->max_len,
			       TRUE,
			       var[0] == 'R'));
	if ((status = pkt_get_field_to_str(pfdd->pkt,
					   var,
					   bs->str,
					   bs->max_len)) < 0)
	  if ((status != -ERR_NOENT &&
	       status != -ERR_NOMETHOD))
	    return (status);
      }
  return (0);
}

t_status		pkt_format(pkt,tmpl_str,prefixes,str,max_len)
t_pkt			*pkt;
char			*tmpl_str;
t_vec			*prefixes;
char			*str;
int			max_len;
{
  t_pkt_format_do_data	pfdd;

  pfdd.pkt = pkt;
  pfdd.prefixes = prefixes;
  return (tmpl_str_to_str(tmpl_str,
			  (t_tmpl_do_proc)pkt_format_do,
			  &pfdd,
			  str,
			  max_len));
}

VOID_FUNC		pkt_show(pkt)
t_pkt			*pkt;
{
  fprintf(stderr,"mp=%p\n",pkt->mp);
  fprintf(stderr,"buf=%p\n",pkt->buf);
  fprintf(stderr,"len=%d\n",pkt->len);;
  fprintf(stderr,"netlen=%p\n",pkt->netlen);
  fprintf(stderr,"ts=%d:%d\n",pkt->ts.tv_sec,pkt->ts.tv_usec);
}

t_pkt			*pkt_dup(pkt,alloc_proc,free_proc,status)
t_pkt			*pkt;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
t_status		*status;
{
  t_pkt			*npkt;

  if ((npkt = alloc_proc(sizeof (t_pkt),"npkt",status)) == NULL)
    return (NULL);
  PKT_COPY(pkt,npkt);
  if ((npkt->buf = alloc_proc(npkt->len * sizeof (char),
			      "npkt->buf",
			      status)) == NULL)
    {
      free_proc(npkt,"npkt");
      return (NULL);
    }
  return (npkt);
}

t_pkt			*pkt_from_xdata(xdata,mp,alloc_proc,free_proc,status)
char			*xdata;
t_msg_proc		mp;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
t_status		*status;
{
  t_pkt			*pkt;
  char			buf[BUFSIZ];
  int			buflen;

  if (((*status) = xdata_to_buf(xdata,buf,&buflen,sizeof (buf))) < 0)
    return (NULL);
  if ((pkt = alloc_proc(sizeof (t_pkt),"pkt",status)) == NULL)
    return (NULL);
  if ((pkt->buf = alloc_proc(buflen * sizeof(char),"pkt->buf",status)) == NULL)
    {
      free_proc(pkt,"pkt");
      return (NULL);
    }
  bcopy(buf,pkt->buf,buflen);
  pkt->mp = mp;
  pkt->len = pkt->netlen = buflen;
  pkt->ts.tv_sec = 0;
  pkt->ts.tv_usec = 0;
  return (pkt);
}
