/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"

t_status			get_field_to_str(buf,
						 len,
						 field,
						 str,
						 max_len)
char				*buf;
int				len;
t_field				*field;
char				*str;
int				max_len;
{
  t_status			status;
  t_extract_data		ed;
  t_bridled_str			bs;

  ed.b.buf = buf + field->offset;
  ed.b.len = len - field->offset;
  ed.data = field->data;
  bs.str = str;
  bs.max_len = max_len;
  if ((status = typ_msg(field->mp,
			TYP_EXTRACT,
			&ed,
			&bs)) < 0)
    return (status);
  return (0);
}

t_status			set_field_from_str(buf,
						   len,
						   field,
						   str)
char				*buf;
int				len;
t_field				*field;
char				*str;
{
  t_status			status;
  t_extract_data		ed;

  ed.b.buf = buf + field->offset;
  ed.b.len = len - field->offset;
  ed.data = field->data;
  if ((status = typ_msg(field->mp,
			TYP_INSERT,
			&ed,
			str)) < 0)
    return (status);
  return (0);
}

#ifdef DEBUG
t_mask			layer_verb_level;

t_mask_def		layer_verb_level_defs[] = 
{
  {"lay_msg",		VERB_LAY_MSG},
  {"typ_msg",		VERB_TYP_MSG},
  {"all",		~0L},
  {NULL,		0}
};

VOID_FUNC		layer_debug_init(VOID_DECL)
{
  char			*str;

  if (str = getenv("LAYER_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = LAYER_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) < 0)
	{
	  err_print(-status,"layer_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(layer_verb_level_defs,
				      vec,
				      &layer_verb_level)) < 0)
	{
	  err_print(-status,"layer_debug_init");
	  abort();
	}
      vec_str_delete(vec);
    }
}
#endif
