/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "miscinet.h"
#include "layeri.h"
#include "lay_ip.h"
#include "lay_udp.h"
#include "lay_data.h"
#include "typ_short.h"
#include "typ_port.h"

/* I'M SURE YOU'LL FIND A BEST WAY TO PERFORM A PORTABLE CHECKSUM! */
unsigned short		udp_cksum(ip)
struct s_ip		*ip;
{
   t_udphdr		*udp;
   unsigned short	*sh;
   unsigned long	sum;
   int			len;
   int			i;
   
   assert(ip_get_len(ip) >= IP_HLEN);
   udp = (t_udphdr *)(((char *)ip) + IP_HLEN);
   len = ntohs(udp->uh_ulen);
   sum = 0;
   sh = (unsigned short *)(&(ip->ip_src));
   i = 0;
   while (i < UDP_ALEN)
     {
       sum += htons(*sh++);
       i++;
     }
   sh = (unsigned short *)udp;
   sum += ip->ip_p + len;
   if (len & 0x1)
   {
      ((char *)udp)[len] = 0;
      len += 1;
   }
   len /= 2;
   i = 0;
   while (i < len)
     {
       sum += htons(*sh++);
       i++;
     }
   sum = (sum >> 16) + (sum & 0xffff);
   sum += (sum >> 16);
   return ((unsigned short)(~sum & 0xffff));
}

int			udp_compute_sum(ip)
struct s_ip		*ip;
{
   t_udphdr		*udp;
   
   udp = (t_udphdr *)((char *)ip + IP_HLEN);
   udp->uh_sum = 0;
   udp->uh_sum = htons(udp_cksum(ip));
}

VOID_FUNC		udp_set_proto(ip)
t_ip			*ip;
{
  ip_set_p(ip,IP_PROTO_UDP);
}

VOID_FUNC		udp_set_sport(udphdr,sport)
t_udphdr		*udphdr;
int			sport;
{
  udphdr->uh_sport = htons((u_short)(sport));
}

int			udp_get_sport(udphdr)
t_udphdr		*udphdr;
{
  return (ntohs(udphdr->uh_sport));
}

VOID_FUNC		udp_set_dport(udphdr,dport)
t_udphdr		*udphdr;
int			dport;
{
  udphdr->uh_dport = htons((u_short)(dport));
}

int			udp_get_dport(udphdr)
t_udphdr		*udphdr;
{
  return (ntohs(udphdr->uh_dport));
}

int			udp_get_ulen(udphdr)
t_udphdr		*udphdr;
{
  return (ntohs(udphdr->uh_ulen));
}

#ifndef WITH_DATA_INTEGRITY
VOID_FUNC		udp_set_ulen(udphdr,ulen)
t_udphdr		*udphdr;
{
  udphdr->uh_ulen = htons(ulen);
}
#endif

VOID_FUNC		udp_set_sum(udphdr,sum)
t_udphdr		*udphdr;
int			sum;
{
  udphdr->uh_sum = htons(sum);
}

int			udp_get_sum(udphdr)
t_udphdr		*udphdr;
{
  return (ntohs(udphdr->uh_sum));
}	

t_status		udp_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_udphdr		*udphdr;

  LAYER_UDP_CHECK(udphdr,buf,len);
  (*sub_mp) = data_msg;
  return (0);
}

t_status		udp_sum(buf,len,up_buf,up_len)
char			*buf;
int			len;
char			*up_buf;
int			up_len;
{
  t_udphdr		*udphdr;
  t_ip			*ip;

  LAYER_UDP_CHECK(udphdr,buf,len);
  LAYER_IP_CHECK(ip,up_buf,up_len);
  udp_compute_sum(ip);
  return (0);
}

t_field				udp_fields[] = 
{
  {"sport",	OFFSET(t_udphdr *,uh_sport),	nushort_msg,		"udp"},
  {"Sport",	OFFSET(t_udphdr *,uh_sport),	port_resolved_msg,	"udp"},
  {"dport",	OFFSET(t_udphdr *,uh_dport),	nushort_msg,		"udp"},
  {"Dport",	OFFSET(t_udphdr *,uh_dport),	port_resolved_msg,	"udp"},
  {"ulen",	OFFSET(t_udphdr *,uh_ulen),	nushort_msg,		NULL},
  {"sum",	OFFSET(t_udphdr *,uh_sum),	nushort_msg,		NULL},
};

t_status			udp_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "udp";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = UDP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (udp_sub(b->buf,b->len,mp));
      }
    case LAY_SUM:
      {
	LAY_SUM_ARGS(sd,unused);
	
	return (udp_sum(sd->b.buf,
			sd->b.len,
			sd->up.buf,
			sd->up.len));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(udp_fields))
	  {
	    if (!strcmp(udp_fields[i].name,gfd->field))
	      field = udp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(udp_fields))
	  {
	    if (!strcmp(udp_fields[i].name,gfd->field))
	      field = udp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
