/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "miscinet.h"
#include "layeri.h"
#include "lay_tcp.h"
#include "lay_ip.h"
#include "lay_data.h"
#include "typ_char.h"
#include "typ_short.h"
#include "typ_long.h"
#include "typ_port.h"
#include "typ_tcpflags.h"

extern t_mask_def	tcp_flags_defs[];

/* I'M SURE YOU'LL FIND A BEST WAY TO PERFORM A PORTABLE CHECKSUM! */
unsigned short		tcp_cksum(ip)
t_ip			*ip;
{
   t_tcphdr		*tcp;
   unsigned short	*sptr;
   unsigned short	len;
   unsigned int		tcksum;
   int			i;
   
   /*assert(ip_get_len(ip) >= IP_HLEN);*/
   tcp = (t_tcphdr *)(((char *)ip) + IP_HLEN);
   tcksum = 0;
   sptr = (unsigned short *)(&(ip->ip_src));
   i = 0;
   while (i < IP_ALEN)
     {
       tcksum += htons(*sptr++);
       i++;
     }
   sptr = (unsigned short *)tcp;
   len = ntohs(ip->ip_len) - IP_HLEN; /* WARNING */
   tcksum += IP_PROTO_TCP + len;
   if (len % 2)
   {
      ((char *)tcp)[len] = 0;
      len += 1;
   }
   len >>= 1;
   i = 0;
   while (i < len)
     {
       tcksum += htons(*sptr++);
       i++;
     }
   tcksum = (tcksum >> 16) + (tcksum & 0xffff);
   tcksum += (tcksum >> 16);
   return ((short)(~tcksum & 0xffff));
}

VOID_FUNC		tcp_compute_sum(ip)
t_ip			*ip;
{
   t_tcphdr		*tcp;
   
   tcp = (t_tcphdr *)(((char *)ip) + IP_HLEN); 
   tcp->th_sum = 0;
   tcp->th_sum = htons(tcp_cksum(ip));
}

VOID_FUNC		tcp_set_proto(ip)
t_ip			*ip;
{
  ip->ip_p = IP_PROTO_TCP;
}

VOID_FUNC		tcp_set_sport(tcphdr,sport)
t_tcphdr		*tcphdr;
int			sport;
{
  tcphdr->th_sport = htons(sport);
}

int			tcp_get_sport(tcphdr)
t_tcphdr		*tcphdr;
{
  return (ntohs(tcphdr->th_sport));
}	

VOID_FUNC		tcp_set_dport(tcphdr,dport)
t_tcphdr		*tcphdr;
int			dport;
{
  tcphdr->th_dport = htons(dport);
}

int			tcp_get_dport(tcphdr)
t_tcphdr		*tcphdr;
{
  return (ntohs(tcphdr->th_dport));
}	

VOID_FUNC		tcp_set_seq(tcphdr,seq)
t_tcphdr		*tcphdr;
t_tcp_seq		seq;
{
  seq = htonl(seq);
  bcopy((char *)(&seq),
	(char *)(&(tcphdr->th_seq)),sizeof (t_tcp_seq)); /* ALIGNMENT */
}

VOID_FUNC		tcp_get_seq(tcphdr,mba_seq) /* ALIGNMENT */
t_tcphdr		*tcphdr;
t_tcp_seq		*mba_seq;
{
  bcopy((char *)(&(tcphdr->th_seq)),(char *)mba_seq,sizeof (t_tcp_seq));
  (*mba_seq) = ntohl(*mba_seq); 
}

VOID_FUNC		tcp_set_ack(tcphdr,ack)
t_tcphdr		*tcphdr;
t_tcp_seq		ack;
{
  ack = htonl(ack);
  bcopy((char *)(&ack),
	(char *)(&(tcphdr->th_ack)),sizeof (t_tcp_seq)); /* ALIGNMENT */
}

VOID_FUNC		tcp_get_ack(tcphdr,mba_ack) /* ALIGNMENT */
t_tcphdr		*tcphdr;
t_tcp_seq		*mba_ack;
{
  bcopy((char *)(&(tcphdr->th_ack)),(char *)mba_ack,sizeof (t_tcp_seq));
  (*mba_ack) = ntohl(*mba_ack); 
}

VOID_FUNC		tcp_set_off(tcp,off)
t_tcphdr		*tcp;
int			off;
{
#ifndef HAVE_BITFIELDS
  int			c;

  c = off;
  c <<= 4;
  tcp->th_offx2 &= 0x0f;
  tcp->th_offx2 |= c;
#else
  tcp->th_off = off;
#endif
}

int			tcp_get_off(tcp)
t_tcphdr		*tcp;
{
#ifndef HAVE_BITFIELDS
  char			c;
  
  c = tcp->th_offx2;
# ifndef WORDS_BIGENDIAN
  c >>= 4;
# endif
  return (c);
#else
  return (tcp->th_off);
#endif
}

VOID_FUNC		tcp_set_x2(tcp,x2)
t_tcphdr		*tcp;
int			x2;
{
#ifndef HAVE_BITFIELDS
  int			c;

  c = x2;
  tcp->th_offx2 &= 0xf0;
  tcp->th_offx2 |= c;
#else
  tcp->th_x2 = x2;
#endif
}

int			tcp_get_x2(tcp)
t_tcphdr		*tcp;
{
#ifndef HAVE_BITFIELDS
  int			c;
  
  c = tcp->th_offx2;
  c &= 0x0f;
  return (c);
#else
  return (tcp->th_x2);
#endif
}

VOID_FUNC		tcp_set_flags(tcphdr,flags)
t_tcphdr		*tcphdr;
int			flags;
{
  tcphdr->th_flags = (u_char)flags;
}

int			tcp_get_flags(tcphdr)
t_tcphdr		*tcphdr;
{
  return (tcphdr->th_flags);
}

VOID_FUNC		tcp_set_win(tcphdr,win)
t_tcphdr		*tcphdr;
int			win;
{
  tcphdr->th_win = htons(win);
}

int			tcp_get_win(tcphdr)
t_tcphdr		*tcphdr;
{
  return (ntohs(tcphdr->th_win));
}	

VOID_FUNC		tcp_set_sum(tcphdr,sum)
t_tcphdr		*tcphdr;
int			sum;
{
  tcphdr->th_sum = htons(sum);
}

int			tcp_get_sum(tcphdr)
t_tcphdr		*tcphdr;
{
  return (ntohs(tcphdr->th_sum));
}

VOID_FUNC		tcp_set_urp(tcphdr,urp)
t_tcphdr		*tcphdr;
int			urp;
{
  tcphdr->th_urp = htons(urp);
}

int			tcp_get_urp(tcphdr)
t_tcphdr		*tcphdr;
{
  return (ntohs(tcphdr->th_urp));
}	

t_status		tcp_off(buf,len,off)
char			*buf;
int			len;
off_t			*off;
{
  t_tcphdr		*tcphdr;

  LAYER_TCP_CHECK(tcphdr,buf,len);
  (*off) = tcp_get_off(tcphdr) * 4;
  return (0);
}

t_status		tcp_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_tcphdr		*tcphdr;

  LAYER_TCP_CHECK(tcphdr,buf,len);
  (*sub_mp) = &data_msg;
  return (0);
}

t_status		tcp_sum(buf,len,up_buf,up_len)
char			*buf;
int			len;
char			*up_buf;
int			up_len;
{
  t_tcphdr		*tcphdr;
  t_ip			*ip;

  LAYER_TCP_CHECK(tcphdr,buf,len);
  LAYER_IP_CHECK(ip,up_buf,up_len);
  tcp_compute_sum(ip);
  return (0);
}

t_status		tcp_flags_to_str(flags,str,max_len,resolve)
int			flags;
char			*str;
int			max_len;
t_boolean		resolve;
{
  t_status		status;
  
  if (!resolve || (status = mask_to_str(tcp_flags_defs,
					flags,
					"|",
					str,
					max_len)) < 0)
    return (uint_to_str(flags,str,max_len));
  return (0);
}

t_field				tcp_fields[] = 
{
  {"sport",	OFFSET(t_tcphdr *,th_sport),	nushort_msg,		"tcp"},
  {"Sport",	OFFSET(t_tcphdr *,th_sport),	port_resolved_msg,	"tcp"},
  {"dport",	OFFSET(t_tcphdr *,th_dport),	nushort_msg,		"tcp"},
  {"Dport",	OFFSET(t_tcphdr *,th_dport),	port_resolved_msg,	"tcp"},
  {"seq",	OFFSET(t_tcphdr *,th_seq),	nulong_msg,		NULL},
  {"ack",	OFFSET(t_tcphdr *,th_ack),	nulong_msg,		NULL},
  {"x2",OFFSET(t_tcphdr *,th_ack) +LONG_LEN,charbit_msg,(VOID_PTR)CHARBIT_0F},
  {"off",OFFSET(t_tcphdr *,th_ack)+LONG_LEN,charbit_msg,(VOID_PTR)CHARBIT_F0},
  {"flags",	OFFSET(t_tcphdr *,th_flags),	charint_msg,		NULL},
  {"Flags",	OFFSET(t_tcphdr *,th_flags),	tcpflags_msg,		NULL},
  {"win",	OFFSET(t_tcphdr *,th_win),	nushort_msg,		NULL},
  {"sum",	OFFSET(t_tcphdr *,th_sum),	nushort_msg,		NULL},
  {"urp",	OFFSET(t_tcphdr *,th_urp),	nushort_msg,		NULL},
};

t_status			tcp_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "tcp";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	return (tcp_off(b->buf,b->len,off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);

	return (tcp_sub(b->buf,b->len,mp));
      }
    case LAY_SUM:
      {
	LAY_SUM_ARGS(sd,unused);
	
	return (tcp_sum(sd->b.buf,
			sd->b.len,
			sd->up.buf,
			sd->up.len));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(tcp_fields))
	  {
	    if (!strcmp(tcp_fields[i].name,gfd->field))
	      field = tcp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(tcp_fields))
	  {
	    if (!strcmp(tcp_fields[i].name,gfd->field))
	      field = tcp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
