/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layeri.h"
#include "lay_pcap.h"
#include "lay_ether.h"
#include "lay_data.h"
#include "pkt.h"
#ifdef WITH_PCAP
# include <pcap-int.h>
#endif

#define NOTREALLYIMPLEMENTED(msg_proc,name,offset) \
t_status		msg_proc(msg,arg1,arg2)\
int			msg;\
VOID_PTR		arg1;\
VOID_PTR		arg2;\
{\
  switch (msg)\
    {\
    case LAY_NAME:\
      {\
	 LAY_NAME_ARGS(unused,n);\
\
	(*n) = name;\
	return (0);\
      }\
    case LAY_OFF:\
      {\
	 LAY_OFF_ARGS(unused,off);\
\
	(*off) = (offset);\
	return (0);\
      }\
    case LAY_SUB:\
      {\
	LAY_SUB_ARGS(unused,mp);\
\
	(*mp) = data_msg;\
	return (0);\
      }\
    }\
  return (-ERR_NOMETHOD);\
}

NOTREALLYIMPLEMENTED(slip_msg,"slip",16)
NOTREALLYIMPLEMENTED(null_msg,"null",4)
NOTREALLYIMPLEMENTED(ppp_msg,"ppp",4)
#if defined(WITH_PCAP) && defined(PCAP_FDDIPAD)
NOTREALLYIMPLEMENTED(fddi_msg,"fddi",21 + PCAP_FDDIPAD)
#else
NOTREALLYIMPLEMENTED(fddi_msg,"fddi",21)
#endif
NOTREALLYIMPLEMENTED(ieee802_msg,"ieee802",22)
NOTREALLYIMPLEMENTED(atm_rfc1483_msg,"atm_rfc1483",8)

#ifdef WITH_PCAP
t_status	layer_get_from_pcap(pcap_link_type,mp)
int		pcap_link_type;
t_msg_proc	*mp;
{
  switch (pcap_link_type)
    {
    case DLT_EN10MB:
      (*mp) = ether_msg;
      return (0);
    case DLT_SLIP:
      (*mp) = &slip_msg;
      return (0);
    case DLT_NULL:
      (*mp) = &null_msg;
      return (0);
    case DLT_PPP:
      (*mp) = &ppp_msg;
      return (0);
    case DLT_FDDI:
      (*mp) = &fddi_msg;
      return (0);
    case DLT_IEEE802:
      (*mp) = &ieee802_msg;
      return (0);
#ifdef DLT_ATM_RFC1483
    case DLT_ATM_RFC1483:
      (*mp) = &atm_rfc1483_msg;
      return (0);
#endif
    }
  return (-ERR_NOENT);
}

t_status		pkt_get(buf,len,caplen,ts,pcap,pkt)
char			*buf;
int			len;
int			caplen;
struct timeval		*ts;
pcap_t			*pcap;
t_pkt			*pkt;		
{
  t_status		status;
  
  if ((status = layer_get_from_pcap(pcap_datalink(pcap),&(pkt->mp))) < 0)
    return (status);
  pkt->buf = buf;
  pkt->len = caplen;
  pkt->netlen = len;
  bcopy((char *)ts,(char *)(&(pkt->ts)),sizeof (struct timeval));
  return (0);
}

t_status		pcap_pkthdr_from_xdata(xdata,
					       alloc_proc,
					       free_proc,
					       buf_return,
					       pp_return)
char			*xdata;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
char			**buf_return;
struct pcap_pkthdr	**pp_return;
{
  t_status		status;
  char			buf[BUFSIZ];
  int			buflen;
  
  if ((status = xdata_to_buf(xdata,buf,&buflen,sizeof (buf))) < 0)
    return (status);
  if (((*pp_return) = alloc_proc(sizeof (struct pcap_pkthdr),
			   "*pp_return",
			   &status)) == NULL)
    return (status);
  if (((*buf_return) = alloc_proc(buflen * sizeof(char),
				  "*buf_return",
				  &status)) == NULL)
    {
      free_proc(*pp_return,"*pp_return");
      return (status);
    }
  bcopy(buf,*buf_return,buflen);
  (*pp_return)->caplen = (*pp_return)->len = buflen;
  (*pp_return)->ts.tv_sec = 0;
  (*pp_return)->ts.tv_usec = 0;
  return (0);
}
#endif
