/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layeri.h"
#include "lay_ether.h"
#include "lay_ip.h"
#include "lay_arp.h"
#include "lay_data.h"
#include "typ_ethaddr.h"
#include "typ_short.h"

VOID_FUNC		ether_set_shost(eh,ea)
t_ether_header		*eh;
t_ether_addr		*ea;
{
  bcopy((char *)ea,(char *)(eh->ether_shost),sizeof (t_ether_addr)); 
}

VOID_FUNC		ether_get_shost(eh,ea)
t_ether_header		*eh;
t_ether_addr		*ea;
{
  bcopy((char *)(eh->ether_shost),(char *)ea,sizeof (t_ether_addr));
}

VOID_FUNC		ether_set_dhost(eh,ea)
t_ether_header		*eh;
t_ether_addr		*ea;
{
  bcopy((char *)ea,(char *)(eh->ether_dhost),sizeof (t_ether_addr)); 
}

VOID_FUNC		ether_get_dhost(eh,ea)
t_ether_header		*eh;
t_ether_addr		*ea;
{
  bcopy((char *)(eh->ether_dhost),(char *)ea,sizeof (t_ether_addr));
}

VOID_FUNC		ether_set_type(eh,type)
t_ether_header		*eh;
int			type;
{
  eh->ether_type = htons(type); 
}

int			ether_get_type(eh)
t_ether_header		*eh;
{
  return (ntohs(eh->ether_type));
}

t_status		ether_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_ether_header	*eh;

  LAYER_ETHER_CHECK(eh,buf,len);
  if (ether_get_type(eh) == ETHER_IP)
    {
      (*sub_mp) = &ip_msg;
      return (0);
    }
  if (ether_get_type(eh) == ETHER_ARP)
    {
      (*sub_mp) = &arp_msg;
      return (0);
    }
  (*sub_mp) = &data_msg;
  return (0);
}

t_field				ether_fields[] = 
{
  {"dhost",	OFFSET(t_ether_header *,ether_dhost),etheraddr_msg,	NULL},
  {"shost",	OFFSET(t_ether_header *,ether_shost),etheraddr_msg,	NULL},
  {"type",	OFFSET(t_ether_header *,ether_type),nushort_msg,	NULL},
};

t_status			ether_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "ether";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ETHER_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (ether_sub(b->buf,b->len,mp));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(ether_fields))
	  {
	    if (!strcmp(ether_fields[i].name,gfd->field))
	      field = ether_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(ether_fields))
	  {
	    if (!strcmp(ether_fields[i].name,gfd->field))
	      field = ether_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
