/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "layer.h"
#include "layeri.h"

t_status			data_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);

	(*name) = "data";
	return (0);
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	
	if (!strcmp(gfd->field,"len"))
	  return (int_to_str(gfd->b.len,
			     bs->str,
			     bs->max_len));
	if (!strcmp(gfd->field,"buf"))
	  return (str_cat_buf(bs->str,
			      bs->max_len,
			      gfd->b.buf,
			      gfd->b.len));
	if (!strcmp(gfd->field,"xbuf"))
	  return (buf_to_xdata_str(gfd->b.buf,
				   gfd->b.len,
				   bs->str,
				   bs->max_len));
	return (-ERR_NOENT);
      }
    }
  return (-ERR_NOMETHOD);
}
