/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layeri.h"
#include "lay_arp.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_arpethip.h"
#include "lay_data.h"
#include "typ_short.h"
#include "typ_char.h"

t_assoc		arp_hrd_assocs[] = 
{
  {"ether",	(VOID_PTR)ARP_HRD_ETHER},
  {"802",	(VOID_PTR)ARP_HRD_802},
  {NULL,	0},
};

t_assoc		arp_op_assocs[] = 
{
  {"request",	(VOID_PTR)ARP_OP_REQUEST},
  {"reply",	(VOID_PTR)ARP_OP_REPLY},
  {NULL,	0},
};

VOID_FUNC	arp_set_hrd(arphdr,hrd)
t_arphdr	*arphdr;
int		hrd;
{
  arphdr->ar_hrd = htons(hrd);
}

int		arp_get_hrd(arphdr)
t_arphdr	*arphdr;
{
  return (ntohs(arphdr->ar_hrd));
}

VOID_FUNC	arp_set_pro(arphdr,pro)
t_arphdr	*arphdr;
int		pro;
{
  arphdr->ar_pro = htons(pro);
}

int		arp_get_pro(arphdr)
t_arphdr	*arphdr;
{
  return (ntohs(arphdr->ar_pro));
}

VOID_FUNC	arp_set_hln(arphdr,hln)
t_arphdr	*arphdr;
int		hln;
{
  arphdr->ar_hln = hln;
}

int		arp_get_hln(arphdr)
t_arphdr	*arphdr;
{
  return (arphdr->ar_hln);
}

VOID_FUNC	arp_set_pln(arphdr,pln)
t_arphdr	*arphdr;
int		pln;
{
  arphdr->ar_pln = pln;
}

int		arp_get_pln(arphdr)
t_arphdr	*arphdr;
{
  return (arphdr->ar_pln);
}

VOID_FUNC	arp_set_op(arphdr,op)
t_arphdr	*arphdr;
int		op;
{
  arphdr->ar_op = htons(op);
}

int		arp_get_op(arphdr)
t_arphdr	*arphdr;
{
  return (ntohs(arphdr->ar_op));
}

t_status	arp_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  t_arphdr	*arphdr;

  LAYER_ARP_CHECK(arphdr,buf,len);
  if (arp_get_hrd(arphdr) == ARP_HRD_ETHER &&
      arp_get_pro(arphdr) == ETHER_IP)
    {
      (*sub_mp) = &arpethip_msg;
      return (0);
    }
  else
    {
      (*sub_mp) = &data_msg;
      return (0);
    }
}

t_status		arp_hrd_to_str(hrd,str,max_len,resolve)
int			hrd;
char			*str;
int			max_len;
t_boolean		resolve;
{
  t_status		status;
  
  if (resolve)
    {
      t_assoc		*assoc;

      if (assoc = assoc_str_int_from_right(arp_hrd_assocs,hrd))
	return (str_cat_str(str,max_len,assoc->left));
    }
  return (uint_to_str(hrd,str,max_len));
}

t_status		arp_op_to_str(op,str,max_len,resolve)
int			op;
char			*str;
int			max_len;
t_boolean		resolve;
{
  t_status		status;
  
  if (resolve)
    {
      t_assoc		*assoc;

      if (assoc = assoc_str_int_from_right(arp_op_assocs,op))
	return (str_cat_str(str,max_len,assoc->left));
    }
  return (uint_to_str(op,str,max_len));
}

t_field				arp_fields[] = 
{
  {"hrd",	OFFSET(t_arphdr *,ar_hrd),	nushort_msg,		NULL},
  {"pro",	OFFSET(t_arphdr *,ar_pro),	nushort_msg,		NULL},
  {"hln",	OFFSET(t_arphdr *,ar_hln),	charint_msg,		NULL},
  {"pln",	OFFSET(t_arphdr *,ar_pln),	charint_msg,		NULL},
  {"op",	OFFSET(t_arphdr *,ar_op),	nushort_msg,		NULL},
};

t_status			arp_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "arp";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ARP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (arp_sub(b->buf,b->len,mp));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(arp_fields))
	  {
	    if (!strcmp(arp_fields[i].name,gfd->field))
	      field = arp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(arp_fields))
	  {
	    if (!strcmp(arp_fields[i].name,gfd->field))
	      field = arp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
