/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef PKT_H
#define PKT_H	1

#include <sys/time.h>
#include "layer.h"

typedef struct			s_pkt
{
  t_msg_proc			mp;
  char				*buf;
  int				len;		/* the "captured" len	*/
  int				netlen;		/* the "real" len	*/
  struct timeval		ts;
} t_pkt;

typedef struct			s_pkt_format_do_data
{
  t_pkt				*pkt;
  t_vec				*prefixes;
} t_pkt_format_do_data;

/* SHALLOW COPY */
#define PKT_COPY(src,dst) bcopy((char *)(src),(char *)dst,sizeof (t_pkt))

/* PROTO pkt.c */
/* pkt.c */
t_status pkt_sub P((t_pkt *pkt, t_pkt *sub_pkt));
t_status pkt_subn P((t_pkt *pkt, t_pkt *subn_pkt, t_msg_proc desired_mp));
t_status pkt_sum P((t_pkt *pkt, t_pkt *up_pkt));
t_status pkt_get_field_to_str P((t_pkt *pkt, char *field, char *str, int max_len));
t_status pkt_set_field_from_str P((t_pkt *pkt, char *field, char *str));
t_status timeval_to_str P((struct timeval *tv, char *str, int max_len, t_boolean resolve));
t_status timeval_to_str_init P((void));
t_status local_to_str P((t_pkt *pkt, t_vec *prefixes, char *str, int max_len, t_boolean remote, t_boolean resolve));
t_status pkt_format_do P((t_bridled_str *bs, char *var, t_pkt_format_do_data *pfdd));
t_status pkt_format P((t_pkt *pkt, char *tmpl_str, t_vec *prefixes, char *str, int max_len));
void pkt_show P((t_pkt *pkt));
t_pkt *pkt_dup P((t_pkt *pkt, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
t_pkt *pkt_from_xdata P((char *xdata, t_msg_proc mp, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
#endif
