/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_UDP_H
#define LAY_UDP_H	1

#include "layer.h"

typedef struct		s_udphdr
{
  u_short		uh_sport;
  u_short		uh_dport;
  u_short		uh_ulen;
  u_short		uh_sum;
} t_udphdr;

#define UDP_HLEN	8
#define UDP_ALEN	4

/*
** - packet len is IP_HLEN + UDP_HLEN + data_len
** - sport + dport are unsigned short
*/

#define LAYER_UDP_CHECK(udppar,bufpar,lenpar) \
	if ((lenpar) < UDP_HLEN)\
		return (-ERR_TRUNC);\
	(udppar) = (t_udphdr *)(bufpar);

/* PROTO lay_udp.c */
/* lay_udp.c */
unsigned short udp_cksum P((struct s_ip *ip));
int udp_compute_sum P((struct s_ip *ip));
void udp_set_proto P((t_ip *ip));
void udp_set_sport P((t_udphdr *udphdr, int sport));
int udp_get_sport P((t_udphdr *udphdr));
void udp_set_dport P((t_udphdr *udphdr, int dport));
int udp_get_dport P((t_udphdr *udphdr));
int udp_get_ulen P((t_udphdr *udphdr));
void udp_set_ulen P((t_udphdr *udphdr, int ulen));
void udp_set_sum P((t_udphdr *udphdr, int sum));
int udp_get_sum P((t_udphdr *udphdr));
t_status udp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status udp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status udp_msg P((int msg, void *arg1, void *arg2));
#endif
