/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_PCAP_H
#define LAY_PCAP_H	1

#include "layer.h"
#include "pkt.h"
#ifdef WITH_PCAP
# include <pcap.h>
#endif

/* PROTO lay_pcap.c */
/* lay_pcap.c */
t_status slip_msg P((int msg, void *arg1, void *arg2));
t_status null_msg P((int msg, void *arg1, void *arg2));
t_status ppp_msg P((int msg, void *arg1, void *arg2));
t_status fddi_msg P((int msg, void *arg1, void *arg2));
t_status ieee802_msg P((int msg, void *arg1, void *arg2));
t_status atm_rfc1483_msg P((int msg, void *arg1, void *arg2));
t_status layer_get_from_pcap P((int pcap_link_type, t_msg_proc *mp));
t_status pkt_get P((char *buf, int len, int caplen, struct timeval *ts, pcap_t *pcap, t_pkt *pkt));
t_status pcap_pkthdr_from_xdata P((char *xdata, t_alloc_proc alloc_proc, t_free_proc free_proc, char **buf_return, struct pcap_pkthdr **pp_return));
#endif
