/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_IP_H
#define LAY_IP_H	1

#include "layer.h"

/* THIS IS REDEFINED TO AVOID SOME INCLUDE PROBLEMS */
typedef struct			s_in_addr
{
  t_u32				s_addr;
} t_in_addr;

typedef struct			s_ip
{
#ifndef HAVE_BITFIELDS 
  u_char			ip_vhl;
#else
# ifndef WORDS_BIGENDIAN
  u_char			ip_hl:4;
  u_char			ip_v:4;
# else
  u_char			ip_v:4;
  u_char			ip_hl:4;
# endif
#endif
  u_char			ip_tos;       
  u_short			ip_len;       
  u_short			ip_id;        
  u_short			ip_off;       
  u_char			ip_ttl;
  u_char			ip_p;  
  u_short			ip_sum;
  t_in_addr			ip_src;
  t_in_addr			ip_dst;
} t_ip;

#define IP_PROTO_IP		0
#define IP_PROTO_ICMP		1
#define IP_PROTO_TCP		6
#define IP_PROTO_UDP		17

#define IP_VERSION		4
#define IP_MAXTTL		255

/*
  The current recommended default time to live (TTL) for the
  Internet Protocol (IP) [45,105] is 64.
  */

#define IP_RECOMMENDEDTTL	64

#define IP_HLEN			20
#define IP_MAXHLEN		(0xf * 4)
#define IP_ALEN			4

#define LAYER_IP_CHECK(ippar,bufpar,lenpar) \
	if ((lenpar) < IP_HLEN)\
		return (-ERR_TRUNC);\
	(ippar) = (t_ip *)(bufpar);

#define IPOPT_EOOL	0
#define IPOPT_NOP	1

/* PROTO lay_ip.c */
/* lay_ip.c */
unsigned short in_cksum P((unsigned short *buf, int nwords));
void ip_compute_sum P((t_ip *ip));
void ip_set_v P((t_ip *ip, int v));
int ip_get_v P((t_ip *ip));
void ip_set_hl P((t_ip *ip, int hl));
int ip_get_hl P((t_ip *ip));
void ip_set_tos P((t_ip *ip, int tos));
int ip_get_tos P((t_ip *ip));
int ip_get_len P((t_ip *ip));
void ip_set_len P((t_ip *ip, int len));
void ip_set_id P((t_ip *ip, int id));
int ip_get_id P((t_ip *ip));
void ip_set_off P((t_ip *ip, int off));
int ip_get_off P((t_ip *ip));
void ip_set_ttl P((t_ip *ip, int ttl));
int ip_get_ttl P((t_ip *ip));
void ip_set_p P((t_ip *ip, int p));
int ip_get_p P((t_ip *ip));
void ip_set_sum P((t_ip *ip, int sum));
int ip_get_sum P((t_ip *ip));
void ip_set_src P((t_ip *ip, t_in_addr *src));
void ip_get_src P((t_ip *ip, t_in_addr *src));
void ip_set_dst P((t_ip *ip, t_in_addr *dst));
void ip_get_dst P((t_ip *ip, t_in_addr *dst));
t_status ip_off P((char *buf, int len, off_t *off));
t_status ip_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status ip_sum P((char *buf, int len, char *up_buf, int up_len));
t_status ip_msg P((int msg, void *arg1, void *arg2));
#endif
