/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ICMP_H
#define LAY_ICMP_H	1

#include "layer.h"
#include "lay_ip.h"

typedef struct		s_icmp
{
  u_char		icmp_type;	/* type of message, see below */
  u_char		icmp_code;	/* type sub code */
  u_short		icmp_cksum;	/* ones complement cksum of struct */
} t_icmp;

/*
 * Lower bounds on packet lengths for various types.
 * For the error advice packets must first insure that the
 * packet is large enought to contain the returned ip header.
 * Only then can we do the check to see if 64 bits of packet
 * data have been returned, since we need to check the returned
 * ip header length.
 */
#define	ICMP_MINLEN	8				/* abs minimum */
#define	ICMP_TSLEN	(8 + 3 * sizeof (n_time))	/* timestamp */
#define	ICMP_MASKLEN	12				/* address mask */
#define	ICMP_ADVLENMIN	(8 + sizeof (struct ip) + 8)	/* min */
#define	ICMP_ADVLEN(p)	(8 + (((p)->icmp_ip.ip_vhl & 0x0f) << 2) + 8)
/* N.B.: must separately check that ip_hl >= 5 */

#define ICMP_HLEN	sizeof (t_icmp)

#define LAYER_ICMP_CHECK(icmppar,bufpar,lenpar) \
	if ((lenpar) < ICMP_HLEN)\
		return (-ERR_TRUNC);\
	(icmppar) = (t_icmp *)(bufpar);

/* PROTO lay_icmp.c */
/* lay_icmp.c */
int icmp_compute_sum P((t_ip *ip, t_icmp *icmp));
void icmp_set_proto P((t_ip *ip));
void icmp_set_type P((t_icmp *icmp, int type));
int icmp_get_type P((t_icmp *icmp));
void icmp_set_code P((t_icmp *icmp, int code));
int icmp_get_code P((t_icmp *icmp));
void icmp_set_cksum P((t_icmp *icmp, int sum));
int icmp_get_cksum P((t_icmp *icmp));
int icmp_sub P((char *buf, int len, t_msg_proc *sub_mp));
int icmp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status icmp_msg P((int msg, void *arg1, void *arg2));
#endif
