/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ETHER_H
#define LAY_ETHER_H	1

#include "layer.h"

typedef struct		s_ether_addr
{
  u_char		o[6];
} t_ether_addr;

typedef struct		s_ether_header			
{
   u_char		ether_dhost[6];
   u_char		ether_shost[6];
   u_short		ether_type;
} t_ether_header;

/*
** - t_ether_header is "data" compatible with sun4's struct ether_header.
*/

#define ETHER_IP	0x0800
#define ETHER_ARP	0x0806

#define ETHER_HLEN	sizeof (t_ether_header)

#define LAYER_ETHER_CHECK(etherpar,bufpar,lenpar) \
	if ((lenpar) < ETHER_HLEN)\
		return (-ERR_TRUNC);\
	(etherpar) = (t_ether_header *)(bufpar);

extern t_assoc		ether_type_assocs[];

/* PROTO lay_ether.c */
/* lay_ether.c */
void ether_set_shost P((t_ether_header *eh, t_ether_addr *ea));
void ether_get_shost P((t_ether_header *eh, t_ether_addr *ea));
void ether_set_dhost P((t_ether_header *eh, t_ether_addr *ea));
void ether_get_dhost P((t_ether_header *eh, t_ether_addr *ea));
void ether_set_type P((t_ether_header *eh, int type));
int ether_get_type P((t_ether_header *eh));
t_status ether_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status ether_msg P((int msg, void *arg1, void *arg2));
#endif
