/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_NODE_H
#define EXP_NODE_H	1

#include "exp.h"

#define NODE_ITEM	0
#define NODE_BOP	1
#define NODE_UOP	2
#define NODE_FUNC	3

struct s_token;

typedef struct		s_node
{
  int			type;
} t_node;

typedef struct		s_node_item
{
  int			type;
  struct s_token	*token;
} t_node_item;

typedef struct		s_node_bop
{
  int			type;
  t_node		*left;
  t_node_item		*bop;
  t_node		*right;
} t_node_bop;

typedef struct		s_node_uop
{
  int			type;
  t_node		*operand;
  t_node_item		*uop;
} t_node_uop;

typedef struct		s_node_func
{
  int			type;
  t_node_item		*caller;
  t_node		*params;
} t_node_func;

/* PROTO exp_node.c */
/* exp_node.c */
t_node_bop *node_bop_new P((t_vec *pool, t_status *status));
void node_bop_delete P((t_node_bop *nbop));
t_node_uop *node_uop_new P((t_vec *pool, t_status *status));
void node_uop_delete P((t_node_uop *nuop));
t_node_func *node_func_new P((t_vec *pool, t_status *status));
void node_func_delete P((t_node_func *nf));
#endif
