/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_CLASS_INT_H
#define EXP_CLASS_INT_H	1

#include "exp_class.h"

#define OBJECT_INT_STR		"int"
#define CLASS_INT_STR		"int"

typedef struct			s_object_int_bop_def
{
  char				*pattern;
  int				prio;
  int				assoc;
  t_eval_bop_is_contr_proc	is_contr_proc;
  t_eval_bop_contr_proc		contr_proc;
  t_eval_bop_proc		proc;
} t_object_int_bop_def;

typedef struct			s_object_int_uop_def
{
  char				*pattern;
  int				prio;
  int				way;
  t_eval_uop_proc		proc;
} t_object_int_uop_def;

typedef struct			s_class_int_data
{
  t_object_manager		*om;
  int				oid;
} t_class_int_data;

extern t_class_def		class_int_def;

/* PROTO exp_class_int.c */
/* exp_class_int.c */
t_status object_int_multiply P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_divide P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_modulus P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_plus P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_minus P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_left_shift P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_right_shift P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_less P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_less_or_equal P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_greater P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_greater_or_equal P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_equal P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_diff P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_and P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_xor P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_or P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_logical_and P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_logical_or P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
t_status object_int_comma P((t_class_int_data *data, t_object *left, t_object *right, t_object **result));
int object_int_logical_and_is_contr P((t_class_int_data *data, t_object *left, t_boolean *ok));
t_status object_int_logical_and_contr P((t_class_int_data *data, t_object *left, t_object **result));
t_status object_int_logical_or_is_contr P((t_class_int_data *data, t_object *left, t_boolean *ok));
t_status object_int_logical_or_contr P((t_class_int_data *data, t_object *left, t_object **result));
t_status object_int_logical_not P((t_class_int_data *data, t_object *operand, t_object **result));
t_status object_int_not P((t_class_int_data *data, t_object *operand, t_object **result));
t_status object_int_unary_plus P((t_class_int_data *data, t_object *operand, t_object **result));
t_status object_int_unary_minus P((t_class_int_data *data, t_object *operand, t_object **result));
t_boolean object_int_sd_match P((void *data, char *text, int len, void *advice));
t_status object_int_eval P((t_class_int_data *data, t_token *token, t_object **result));
t_status object_int_sd_cvt P((t_class_int_data *data, char *text, int len, void *advice, t_token *token));
void object_int_show P((t_object *o));
void object_int_delete P((t_object *o));
int object_int_dup P((t_object *src, t_object *dst));
int object_int_sd_delete P((void *delete_data, t_scan_drv *sd));
void class_int_tilde P((t_class_int_data *data));
t_status class_int P((t_object_manager *om, t_class_int_data **data));
#endif
