/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_CLASS_BASE_H
#define EXP_CLASS_BASE_H	1

#include "exp_class.h"

#define OBJECT_PTRFUNC_STR	"ptrfunc"
#define OBJECT_VOID_STR		"void"
#define CLASS_BASE_STR		"base"

typedef struct			s_class_base_data
{
  t_object_manager		*om;
  int				ptrfunc_oid;
  int				void_oid;
} t_class_base_data;

typedef struct			s_func_data
{
  char				*name;
  t_eval_func_proc		proc;
  VOID_PTR			data;
  t_class_base_data		*class_base_data;
} t_func_data;

extern t_class_def		class_base_def;

/* PROTO exp_class_base.c */
/* exp_class_base.c */
int object_base_bop_comma P((t_object_manager *data, t_object *left, t_object *right, t_object **result));
t_boolean class_base_space_sd_match P((void *data, char *text, int len, void *advice));
t_boolean class_base_lp_sd_match P((void *data, char *text, int len, void *advice));
int class_base_lp_sd_cvt P((void *data, char *text, int len, void *advice, t_token *token));
t_boolean class_base_rp_sd_match P((void *data, char *text, int len, void *advice));
int class_base_rp_sd_cvt P((void *data, char *text, int len, void *advice, t_token *token));
t_status class_base_space P((t_object_manager *om));
t_status class_base_lp P((t_object_manager *om));
t_status class_base_rp P((t_object_manager *om));
t_status class_base_comma P((t_object_manager *om));
t_status class_base_func_show P((t_token *token, t_node *node, void **result));
t_boolean class_base_func_sd_match P((t_func_data *func_data, char *text, int len, void *advice));
t_status class_base_func_sd_cvt P((t_func_data *func_data, char *text, int len, void *advice, t_token *token));
t_status exp_register_func P((t_class_base_data *class_base_data, const char *name, t_eval_func_proc proc, void *data));
t_status exp_func_node_to_vec P((t_node *node, t_vec *vec));
t_status object_ptrfunc_eval P((t_class_base_data *data, t_token *token, t_object **result));
void object_ptrfunc_show P((t_object *o));
void object_ptrfunc_delete P((t_object *o));
int object_ptrfunc_dup P((t_object *src, t_object *dst));
t_status class_base_ptrfunc P((t_class_base_data *data));
t_status object_void_eval P((t_class_base_data *data, t_token *token, t_object **result));
void object_void_show P((t_object *o));
void object_void_delete P((t_object *o));
t_status object_void_dup P((t_object *src, t_object *dst));
t_status class_base_void P((t_class_base_data *data));
void class_base_tilde P((t_class_base_data *data));
t_status class_base P((t_object_manager *om, t_class_base_data **data));
#endif
