/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_compil.h"
#include "exp_show.h"

t_status		show_node_item(f,ni,deep)
FILE			*f;
t_node_item		*ni;
t_boolean		deep;
{
  if (exp_keep_text)
    fprintf(f,"%s",ni->token->token_show.text);
  else
    fprintf(f,"?");
  return (0);
}

t_status		show_node_bop(f,nbop,deep)
FILE			*f;
t_node_bop		*nbop;
t_boolean		deep;
{
  t_status		status;

  if (deep)
    {
      fprintf(f,"(");
      if ((status = show_node(f,nbop->left,deep)) < 0)
	return (status);
    }
  if ((status = show_node_item(f,nbop->bop,deep)) < 0)
    return (status);
  if (deep)
    {
      if ((status = show_node(f,nbop->right,deep)) < 0)
	return (status);
      fprintf(f,")");
    }
}

t_status		show_node_uop(f,nuop,deep)
FILE			*f;
t_node_uop		*nuop;
t_boolean		deep;
{
  t_status		status;

  if (deep)
    {
      fprintf(f,"(");
    }
  if ((status = show_node_item(f,nuop->uop,deep)) < 0)
    return (status);
  if (deep)
    {
      if ((status = show_node(f,nuop->operand,deep)) < 0)
	return (status);
      fprintf(f,")");
    }
}

t_status		show_node_func(f,nf,deep)
FILE			*f;
t_node_func		*nf;
t_boolean		deep;
{
  t_status		status;

  if ((status = show_node_item(f,nf->caller,deep)) < 0)
    return (status);
  fprintf(f,"(");
  if (deep)
    {
      if (nf->params)
	if ((status = show_node(f,nf->params,deep)) < 0)
	  return (status);
    }
  fprintf(f,")");
  return (0);
}

t_show_proc		show_procs[] =
{
  (t_show_proc)show_node_item,
  (t_show_proc)show_node_bop,
  (t_show_proc)show_node_uop,
  (t_show_proc)show_node_func
};

int			show_node(f,node,deep)
FILE			*f;
t_node			*node;
t_boolean		deep;
{
  int			status;

  assert(node->type < ARRAY_COUNT(show_procs));
  status = show_procs[node->type](f,node,deep);
  return (status);
}
