/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_compil.h"

t_node_bop		*node_bop_new(pool,status)
t_vec			*pool;
t_status		*status;
{
  t_node_bop		*nbop;

  if ((nbop = EXP_ALLOC_PROC(sizeof (t_node_bop),"nbop",status)) == NULL)
    return (NULL);
  nbop->type = NODE_BOP;
  if (((*status) = vec_add(pool,nbop)) < 0)
    {
      EXP_FREE_PROC(nbop,"nbop");
      return (NULL);
    }
  return (nbop);
}

VOID_FUNC		node_bop_delete(nbop)
t_node_bop		*nbop;
{
  EXP_FREE_PROC(nbop,"nbop");
}

t_node_uop		*node_uop_new(pool,status)
t_vec			*pool;
t_status		*status;
{
  t_node_uop		*nuop;

  if ((nuop = EXP_ALLOC_PROC(sizeof (t_node_uop),"nuop",status)) == NULL)
    return (NULL);
  nuop->type = NODE_UOP;
  if (((*status) = vec_add(pool,nuop)) < 0)
    {
      EXP_FREE_PROC(nuop,"nuop");
      return (NULL);
    }
  return (nuop);
}

VOID_FUNC		node_uop_delete(nuop)
t_node_uop		*nuop;
{
  EXP_FREE_PROC(nuop,"nuop");
}

t_node_func		*node_func_new(pool,status)
t_vec			*pool;
t_status		*status;
{
  t_node_func		*nf;

  if ((nf = EXP_ALLOC_PROC(sizeof (t_node_func),"nf",status)) == NULL)
    return (NULL);
  nf->type = NODE_FUNC;
  if (((*status) = vec_add(pool,nf)) < 0)
    {
      EXP_FREE_PROC(nf,"nf");
      return (NULL);
    }
  return (nf);
}

VOID_FUNC		node_func_delete(nf)
t_node_func		*nf;
{
  EXP_FREE_PROC(nf,"nf");
}
